/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.EntityAIAttackPattern;
import maninthehouse.epicfight.entity.ai.EntityAIChase;
import maninthehouse.epicfight.entity.ai.EntityAIPatternWithChance;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.gamedata.Sounds;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;

public class IronGolemData
extends BipedMobData<EntityIronGolem> {
    private int deathTimerExt;

    public IronGolemData() {
        super(Faction.VILLAGER);
    }

    @Override
    public void onEntityJoinWorld(EntityIronGolem entityIn) {
        super.onEntityJoinWorld(entityIn);
        ((EntityIronGolem)this.orgEntity).field_70144_Y = 0.2f;
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EntityIronGolem)this.orgEntity).func_110148_a(ModAttributes.MAX_STRIKES).func_111128_a(4.0);
        ((EntityIronGolem)this.orgEntity).func_110148_a(ModAttributes.IMPACT).func_111128_a(10.0);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Root", "Torso");
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.GOLEM_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.GOLEM_WALK);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.GOLEM_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public void update() {
        if (((EntityIronGolem)this.orgEntity).func_110143_aJ() <= 0.0f) {
            ((EntityIronGolem)this.orgEntity).field_70125_A = 0.0f;
            if (((EntityIronGolem)this.orgEntity).field_70725_aQ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((EntityIronGolem)this.orgEntity).field_70725_aQ;
            }
        }
        super.update();
    }

    @Override
    public void setAIAsUnarmed() {
        ((EntityIronGolem)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPatternWithChance(this, (EntityCreature)this.orgEntity, 0.0, 1.5, 0.3f, true, MobAttackPatterns.GOLEM_PATTERN1));
        ((EntityIronGolem)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPatternWithChance(this, (EntityCreature)this.orgEntity, 1.0, 2.5, 0.15f, true, MobAttackPatterns.GOLEM_PATTERN2));
        ((EntityIronGolem)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 2.0, true, MobAttackPatterns.GOLEM_PATTERN3));
        ((EntityIronGolem)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIChase(this, (EntityCreature)this.orgEntity, 1.0, false));
    }

    @Override
    public void setAIAsArmed() {
        this.setAIAsUnarmed();
    }

    @Override
    public SoundEvent getWeaponHitSound(EnumHand hand) {
        return Sounds.BLUNT_HIT_HARD;
    }

    @Override
    public SoundEvent getSwingSound(EnumHand hand) {
        return Sounds.WHOOSH_BIG;
    }

    @Override
    public float getDamageToEntity(Entity targetEntity, EnumHand hand) {
        return 7 + ((EntityIronGolem)this.orgEntity).func_70681_au().nextInt(15);
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        return null;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_GOLEM;
    }
}

