/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import java.util.Iterator;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.MobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.EntityAICreeperSwellStoppable;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.util.math.MathHelper;

public class CreeperData
extends MobData<EntityCreeper> {
    public CreeperData() {
        super(Faction.NATURAL);
    }

    @Override
    protected void initAI() {
        Iterator iterator = ((EntityCreeper)this.orgEntity).field_70714_bg.field_75782_a.iterator();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            EntityAIBase entityAI = entityaitasks$entityaitaskentry.field_75733_a;
            if (!(entityAI instanceof EntityAICreeperSwell)) continue;
            iterator.remove();
        }
        ((EntityCreeper)this.orgEntity).field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwellStoppable(this, (EntityCreeper)this.orgEntity));
    }

    @Override
    protected void initAnimator(AnimatorClient animator) {
        animator.addLivingAnimation(LivingMotion.IDLE, Animations.CREEPER_IDLE);
        animator.addLivingAnimation(LivingMotion.WALKING, Animations.CREEPER_WALK);
        animator.addLivingAnimation(LivingMotion.DEATH, Animations.CREEPER_DEATH);
        animator.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        VisibleMatrix4f mat = super.getModelMatrix(partialTicks);
        if (this.isRemote()) {
            float f = ((EntityCreeper)this.orgEntity).func_70831_j(partialTicks);
            float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f2 = (1.0f + f * 0.4f) * f1;
            float f3 = (1.0f + f * 0.1f) / f1;
            VisibleMatrix4f.scale(new Vec3f(f2, f3, f2), mat, mat);
        }
        return mat;
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.CREEPER_HIT_LONG;
        }
        return Animations.CREEPER_HIT_SHORT;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_CREEPER;
    }
}

