/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.MobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.EntityAIArcher;
import maninthehouse.epicfight.entity.ai.EntityAIAttackPattern;
import maninthehouse.epicfight.entity.ai.EntityAIChase;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.world.EnumDifficulty;

public abstract class BipedMobData<T extends EntityCreature>
extends MobData<T> {
    public BipedMobData(Faction faction) {
        super(faction);
    }

    @Override
    public void postInit() {
        if (!this.isRemote() && !((EntityCreature)this.orgEntity).func_175446_cd()) {
            super.resetCombatAI();
            Item heldItem = ((EntityCreature)this.orgEntity).func_184614_ca().func_77973_b();
            if (heldItem instanceof ItemBow && this.orgEntity instanceof IRangedAttackMob) {
                this.setAIAsRange();
            } else if (((EntityCreature)this.orgEntity).func_184187_bx() != null && ((EntityCreature)this.orgEntity).func_184187_bx() instanceof EntityMob) {
                this.setAIAsMounted(((EntityCreature)this.orgEntity).func_184187_bx());
            } else if (this.isArmed()) {
                this.setAIAsArmed();
            } else {
                this.setAIAsUnarmed();
            }
        }
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        animatorClient.mixLayer.setJointMask("Root", "Torso");
    }

    public void setAIAsUnarmed() {
    }

    public void setAIAsArmed() {
        ((EntityCreature)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 2.0, true, MobAttackPatterns.BIPED_ARMED_ONEHAND));
        ((EntityCreature)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIChase(this, (EntityCreature)this.orgEntity, 1.0, false));
    }

    public void setAIAsMounted(Entity ridingEntity) {
        if (this.isArmed() && this.isArmed()) {
            ((EntityCreature)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 2.0, true, MobAttackPatterns.BIPED_MOUNT_SWORD));
            if (ridingEntity instanceof AbstractHorse) {
                ((EntityCreature)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIChase(this, (EntityCreature)this.orgEntity, 1.0, false));
            }
        }
    }

    public void setAIAsRange() {
        int cooldown = ((EntityCreature)this.orgEntity).field_70170_p.func_175659_aa() != EnumDifficulty.HARD ? 40 : 20;
        ((EntityCreature)this.orgEntity).field_70714_bg.func_75776_a(1, new EntityAIArcher<EntityCreature>(this, (EntityCreature)this.orgEntity, 1.0, cooldown, 15.0f));
    }

    public boolean isArmed() {
        Item heldItem = ((EntityCreature)this.orgEntity).func_184614_ca().func_77973_b();
        return heldItem instanceof ItemSword || heldItem instanceof ItemTool;
    }

    public void onMount(boolean isMount, Entity ridingEntity) {
        if (this.orgEntity == null) {
            return;
        }
        this.resetCombatAI();
        if (isMount) {
            this.setAIAsMounted(ridingEntity);
        } else if (this.isArmed()) {
            this.setAIAsArmed();
        } else {
            this.setAIAsUnarmed();
        }
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (((EntityCreature)this.orgEntity).func_184187_bx() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: {
                return Animations.BIPED_HIT_SHORT;
            }
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
        }
        return null;
    }
}

