/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.item.ArmorCapability;
import maninthehouse.epicfight.capabilities.item.AxeCapability;
import maninthehouse.epicfight.capabilities.item.BowCapability;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.capabilities.item.HoeCapability;
import maninthehouse.epicfight.capabilities.item.PickaxeCapability;
import maninthehouse.epicfight.capabilities.item.ShovelCapability;
import maninthehouse.epicfight.capabilities.item.SwordCapability;
import maninthehouse.epicfight.capabilities.item.VanillaArmorCapability;
import maninthehouse.epicfight.config.ConfigurationCapability;
import maninthehouse.epicfight.main.EpicFightMod;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ProviderItem
implements ICapabilityProvider {
    private static final Map<Item, CapabilityItem> CAPABILITY_BY_INSTANCE = new HashMap<Item, CapabilityItem>();
    private static final Map<Class<? extends Item>, Function<Item, CapabilityItem>> CAPABILITY_BY_CLASS = new HashMap<Class<? extends Item>, Function<Item, CapabilityItem>>();
    private CapabilityItem capability;

    public static void makeMap() {
        ProviderItem.addCustomItemCapabilities();
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151053_p, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151049_t, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151036_c, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151006_E, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151056_x, AxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151039_o, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151050_s, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151035_b, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151005_D, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151046_w, PickaxeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151017_I, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151018_J, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151019_K, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151013_M, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151012_L, HoeCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151038_n, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151051_r, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151037_a, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151011_C, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151047_v, ShovelCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151041_m, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151052_q, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151040_l, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151010_B, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent(Items.field_151048_u, SwordCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151021_T, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151027_R, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151024_Q, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151026_S, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151151_aj, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151171_ah, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151169_ag, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151149_ai, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151029_X, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151023_V, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151020_U, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151022_W, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151167_ab, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151030_Z, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151028_Y, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151165_aa, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151175_af, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151163_ad, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151161_ac, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151173_ae, VanillaArmorCapability::new);
        CAPABILITY_BY_INSTANCE.computeIfAbsent((Item)Items.field_151031_f, BowCapability::new);
        CAPABILITY_BY_CLASS.put(ItemSword.class, SwordCapability::new);
        CAPABILITY_BY_CLASS.put(ItemPickaxe.class, PickaxeCapability::new);
        CAPABILITY_BY_CLASS.put(ItemAxe.class, AxeCapability::new);
        CAPABILITY_BY_CLASS.put(ItemSpade.class, ShovelCapability::new);
        CAPABILITY_BY_CLASS.put(ItemHoe.class, HoeCapability::new);
        CAPABILITY_BY_CLASS.put(ItemBow.class, BowCapability::new);
        CAPABILITY_BY_CLASS.put(ItemArmor.class, ArmorCapability::new);
    }

    public static void addInstance(Item item, CapabilityItem cap) {
        CAPABILITY_BY_INSTANCE.put(item, cap);
    }

    public static void addCustomItemCapabilities() {
        CapabilityItem cap;
        Item item;
        for (ConfigurationCapability.WeaponConfig weaponConfig : ConfigurationCapability.getWeaponConfigs()) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(weaponConfig.registryName));
            if (item != null) {
                EpicFightMod.LOGGER.info("Register Custom Capaiblity for " + weaponConfig.registryName);
                cap = weaponConfig.weaponType.get();
                cap.addStyleAttributeSimple(CapabilityItem.WieldStyle.ONE_HAND, weaponConfig.onehand.armorNegation, weaponConfig.onehand.impact, weaponConfig.onehand.maxStrikes);
                cap.addStyleAttributeSimple(CapabilityItem.WieldStyle.TWO_HAND, weaponConfig.twohand.armorNegation, weaponConfig.twohand.impact, weaponConfig.twohand.maxStrikes);
                CAPABILITY_BY_INSTANCE.put(item, cap);
                continue;
            }
            EpicFightMod.LOGGER.warn("Failed to load custom item " + weaponConfig.registryName + ". Item not exist!");
        }
        for (ConfigurationCapability.ArmorConfig armorConfig : ConfigurationCapability.getArmorConfigs()) {
            try {
                item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(armorConfig.registryName));
                if (item != null && item instanceof ItemArmor) {
                    cap = new ArmorCapability(item, armorConfig.weight, armorConfig.stunArmor);
                    CAPABILITY_BY_INSTANCE.put(item, cap);
                    EpicFightMod.LOGGER.info("Register Custom Capaiblity for " + armorConfig.registryName);
                    continue;
                }
                if (item == null) {
                    EpicFightMod.LOGGER.warn("Failed to load custom item " + armorConfig.registryName + ". Item not exist!");
                    continue;
                }
                if (item instanceof ItemArmor) continue;
                EpicFightMod.LOGGER.warn("Failed to load custom item " + armorConfig.registryName + ". Item is not armor!");
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.warn("Failed to load custom item " + armorConfig.registryName);
                System.err.println(e);
            }
        }
    }

    public ProviderItem(Item item, boolean autogenerate) {
        this.capability = CAPABILITY_BY_INSTANCE.get(item);
        if (this.capability == null && autogenerate) {
            this.capability = this.makeCustomCapability(item);
            if (this.capability != null) {
                CAPABILITY_BY_INSTANCE.put(item, this.capability);
            }
        }
    }

    private CapabilityItem makeCustomCapability(Item item) {
        CapabilityItem cap = null;
        for (Class<?> clazz = item.getClass(); clazz != null && cap == null; clazz = clazz.getSuperclass()) {
            cap = CAPABILITY_BY_CLASS.getOrDefault(clazz, argIn -> null).apply(item);
        }
        return cap;
    }

    public boolean hasCapability() {
        return this.capability != null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == ModCapabilities.CAPABILITY_ITEM && this.capability != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == ModCapabilities.CAPABILITY_ITEM && this.capability != null) {
            return (T)this.capability;
        }
        return null;
    }
}

