/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.animation.types.attack;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import maninthehouse.epicfight.animation.Animator;
import maninthehouse.epicfight.animation.JointTransform;
import maninthehouse.epicfight.animation.Pose;
import maninthehouse.epicfight.animation.Quaternion;
import maninthehouse.epicfight.animation.types.ActionAnimation;
import maninthehouse.epicfight.animation.types.AnimationProperty;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.MobData;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.physics.Collider;
import maninthehouse.epicfight.utils.game.AttackResult;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;

public class AttackAnimation
extends ActionAnimation {
    protected final Map<AnimationProperty<?>, Object> properties = new HashMap();
    protected final Phase[] phases;

    public AttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new Phase(antic, preDelay, contact, recovery, index, collider));
    }

    public AttackAnimation(int id, float convertTime, float antic, float preDelay, float contact, float recovery, boolean affectY, EnumHand hand, @Nullable Collider collider, String index, String path) {
        this(id, convertTime, affectY, path, new Phase(antic, preDelay, contact, recovery, hand, index, collider));
    }

    public AttackAnimation(int id, float convertTime, boolean affectY, String path, Phase ... phases) {
        super(id, convertTime, true, affectY, path);
        this.phases = phases;
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        block8: {
            Phase phase;
            LivingData.EntityState prevState;
            LivingData.EntityState state;
            float elapsedTime;
            block9: {
                super.onUpdate(entitydata);
                if (entitydata.isRemote()) break block8;
                elapsedTime = ((Animator)entitydata.getAnimator()).getPlayer().getElapsedTime();
                float prevElapsedTime = ((Animator)entitydata.getAnimator()).getPlayer().getPrevElapsedTime();
                state = this.getState(elapsedTime);
                prevState = this.getState(prevElapsedTime);
                phase = this.getCurrentPhase(elapsedTime);
                if (state != LivingData.EntityState.FREE_CAMERA) break block9;
                if (!(entitydata instanceof MobData)) break block8;
                ((EntityCreature)entitydata.getOriginalEntity()).func_70661_as().func_75499_g();
                EntityLivingBase target = entitydata.getAttackTarget();
                if (target != null) {
                    entitydata.rotateTo((Entity)target, 60.0f, false);
                }
                break block8;
            }
            if (state.shouldDetectCollision() || prevState.getLevel() < 2 && state.getLevel() > 2) {
                if (!prevState.shouldDetectCollision()) {
                    entitydata.playSound(this.getSwingSound(entitydata, phase.hand), 0.0f, 0.0f);
                    entitydata.currentlyAttackedEntity.clear();
                }
                Collider collider = this.getCollider(entitydata, elapsedTime);
                Object entity = entitydata.getOriginalEntity();
                entitydata.getEntityModel(Models.LOGICAL_SERVER).getArmature().initializeTransform();
                VisibleMatrix4f jointTransform = entitydata.getServerAnimator().getColliderTransformMatrix(phase.jointIndexer);
                collider.transform(VisibleMatrix4f.mul(entitydata.getModelMatrix(1.0f), jointTransform, null));
                List list = ((EntityLivingBase)entity).field_70170_p.func_72839_b(entity, collider.getHitboxAABB());
                collider.extractHitEntities(list);
                if (list.size() > 0) {
                    AttackResult attackResult = new AttackResult((Entity)entity, list);
                    boolean flag1 = true;
                    while (entitydata.currentlyAttackedEntity.size() < this.getHitEnemies(entitydata)) {
                        Entity e = attackResult.getEntity();
                        Entity trueEntity = this.getTrueEntity(e);
                        if (!entitydata.currentlyAttackedEntity.contains(trueEntity) && !entitydata.isTeam(e) && (e instanceof EntityLivingBase || e instanceof MultiPartEntityPart) && e.field_70170_p.func_147447_a(new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v), new Vec3d(((EntityLivingBase)entity).field_70165_t, ((EntityLivingBase)entity).field_70163_u + (double)entity.func_70047_e(), ((EntityLivingBase)entity).field_70161_v), false, true, false) == null) {
                            IExtendedDamageSource source = this.getDamageSourceExt(entitydata, e);
                            if (entitydata.hurtEntity(e, phase.hand, source, this.getDamageAmount(entitydata, e, phase.hand))) {
                                entity.func_130011_c(e);
                                e.field_70172_ad = 0;
                                e.field_70170_p.func_184148_a(null, e.field_70165_t, e.field_70163_u, e.field_70161_v, this.getHitSound(entitydata, phase.hand), e.func_184176_by(), 1.0f, 1.0f);
                                if (flag1 && entitydata instanceof PlayerData && trueEntity instanceof EntityLivingBase) {
                                    entitydata.getOriginalEntity().func_184586_b(phase.hand).func_77961_a((EntityLivingBase)trueEntity, (EntityPlayer)((PlayerData)entitydata).getOriginalEntity());
                                }
                                flag1 = false;
                            }
                            entitydata.currentlyAttackedEntity.add(trueEntity);
                        }
                        if (attackResult.next()) continue;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void onFinish(LivingData<?> entitydata, boolean isEnd) {
        EntityCreature entity;
        super.onFinish(entitydata, isEnd);
        entitydata.currentlyAttackedEntity.clear();
        if (entitydata instanceof BipedMobData && entitydata.isRemote() && (entity = (EntityCreature)entitydata.getOriginalEntity()).func_70638_az() != null && !entity.func_70638_az().func_70089_S()) {
            entity.func_70624_b((EntityLivingBase)null);
        }
    }

    @Override
    public LivingData.EntityState getState(float time) {
        Phase phase = this.getCurrentPhase(time);
        boolean lockCameraRotation = this.getProperty(AnimationProperty.LOCK_ROTATION).orElse(false);
        if (phase.antic >= time) {
            return LivingData.EntityState.FREE_CAMERA;
        }
        if (phase.antic < time && phase.preDelay > time) {
            return LivingData.EntityState.FREE_CAMERA;
        }
        if (phase.preDelay <= time && phase.contact >= time) {
            return lockCameraRotation ? LivingData.EntityState.CONTACT : LivingData.EntityState.ROTATABLE_CONTACT;
        }
        if (phase.recovery > time) {
            return lockCameraRotation ? LivingData.EntityState.POST_DELAY : LivingData.EntityState.ROTATABLE_POST_DELAY;
        }
        return LivingData.EntityState.FREE_INPUT;
    }

    public Collider getCollider(LivingData<?> entitydata, float elapsedTime) {
        Phase phase = this.getCurrentPhase(elapsedTime);
        return phase.collider != null ? phase.collider : entitydata.getColliderMatching(phase.hand);
    }

    public Entity getTrueEntity(Entity entity) {
        if (entity instanceof MultiPartEntityPart) {
            IEntityMultiPart parent = ((MultiPartEntityPart)entity).field_70259_a;
            if (parent instanceof Entity) {
                return (Entity)parent;
            }
            return null;
        }
        return entity;
    }

    protected int getHitEnemies(LivingData<?> entitydata) {
        return this.getProperty(AnimationProperty.HIT_AT_ONCE).orElse(entitydata.getHitEnemies());
    }

    protected float getDamageAmount(LivingData<?> entitydata, Entity target, EnumHand hand) {
        float multiplier = this.getProperty(AnimationProperty.DAMAGE_MULTIPLIER).orElse(Float.valueOf(1.0f)).floatValue();
        float adder = this.getProperty(AnimationProperty.DAMAGE_ADDER).orElse(Float.valueOf(0.0f)).floatValue();
        return entitydata.getDamageToEntity(target, hand) * multiplier + adder;
    }

    protected SoundEvent getSwingSound(LivingData<?> entitydata, EnumHand hand) {
        return this.getProperty(AnimationProperty.SWING_SOUND).orElse(entitydata.getSwingSound(hand));
    }

    protected SoundEvent getHitSound(LivingData<?> entitydata, EnumHand hand) {
        return this.getProperty(AnimationProperty.HIT_SOUND).orElse(entitydata.getWeaponHitSound(hand));
    }

    protected IExtendedDamageSource getDamageSourceExt(LivingData<?> entitydata, Entity target) {
        IExtendedDamageSource.DamageType dmgType = this.getProperty(AnimationProperty.DAMAGE_TYPE).orElse(IExtendedDamageSource.DamageType.PHYSICAL);
        IExtendedDamageSource.StunType stunType = this.getProperty(AnimationProperty.STUN_TYPE).orElse(IExtendedDamageSource.StunType.SHORT);
        IExtendedDamageSource extDmgSource = entitydata.getDamageSource(stunType, dmgType, this.getId());
        this.getProperty(AnimationProperty.ARMOR_NEGATION).ifPresent(opt -> extDmgSource.setArmorIgnore(opt.floatValue()));
        this.getProperty(AnimationProperty.IMPACT).ifPresent(opt -> extDmgSource.setImpact(opt.floatValue()));
        return extDmgSource;
    }

    public <T> AttackAnimation addProperty(AnimationProperty<T> propertyType, T value) {
        this.properties.put(propertyType, value);
        return this;
    }

    public void addProperties(Set<Map.Entry<AnimationProperty<?>, Object>> set) {
        for (Map.Entry<AnimationProperty<?>, Object> entry : set) {
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    protected <T> Optional<T> getProperty(AnimationProperty<T> propertyType) {
        return Optional.ofNullable(this.properties.get(propertyType));
    }

    public int getIndexer(float elapsedTime) {
        return this.getCurrentPhase((float)elapsedTime).jointIndexer;
    }

    public Phase getCurrentPhase(float elapsedTime) {
        Phase currentPhase = null;
        Phase[] phaseArray = this.phases;
        int n = phaseArray.length;
        for (int i = 0; i < n; ++i) {
            Phase phase;
            currentPhase = phase = phaseArray[i];
            if (phase.recovery > elapsedTime) break;
        }
        return currentPhase;
    }

    @Override
    public Pose getPoseByTime(LivingData<?> entitydata, float time) {
        Pose pose = super.getPoseByTime(entitydata, time);
        this.getProperty(AnimationProperty.DIRECTIONAL).ifPresent(b -> {
            float pitch = entitydata.getAttackDirectionPitch();
            JointTransform chest = pose.getTransformByName("Chest");
            chest.setCustomRotation(Quaternion.rotate((float)Math.toRadians(pitch), new Vec3f(1.0f, 0.0f, 0.0f), null));
            if (entitydata instanceof PlayerData) {
                JointTransform head = pose.getTransformByName("Head");
                head.setRotation(Quaternion.rotate((float)(-Math.toRadians(pitch)), new Vec3f(1.0f, 0.0f, 0.0f), head.getRotation()));
            }
        });
        return pose;
    }

    @Deprecated
    public void changeCollider(Collider newCollider, int index) {
        this.phases[index].collider = newCollider;
    }

    public static class Phase {
        protected final float antic;
        protected final float preDelay;
        protected final float contact;
        protected final float recovery;
        protected final int jointIndexer;
        protected final EnumHand hand;
        protected Collider collider;

        public Phase(float antic, float preDelay, float contact, float recovery, String indexer, Collider collider) {
            this(antic, preDelay, contact, recovery, EnumHand.MAIN_HAND, indexer, collider);
        }

        public Phase(float antic, float preDelay, float contact, float recovery, EnumHand hand, String indexer, Collider collider) {
            this.antic = antic;
            this.preDelay = preDelay;
            this.contact = contact;
            this.recovery = recovery;
            this.collider = collider;
            this.hand = hand;
            int coded = 0;
            if (indexer.length() == 0) {
                this.jointIndexer = -1;
            } else {
                for (int i = 0; i < indexer.length(); ++i) {
                    int value = indexer.charAt(i) - 48;
                    coded |= value;
                    coded <<= 5;
                }
                this.jointIndexer = coded;
            }
        }
    }
}

