/*
 * Decompiled with CFR 0.152.
 */
package deconstruction.common.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import deconstruction.common.handler.DeconRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class DeconstructionManager {
    public static DeconstructionManager instance = new DeconstructionManager();
    public static Multimap<String, DeconRecipe> recipeMap = HashMultimap.create();

    public void addRecipe(IRecipe recipe) {
        this.addRecipe(new DeconRecipe(recipe));
    }

    public boolean addRecipe(ItemStack result, ItemStack[] ingredients, int width, int height, boolean shapeless) {
        return this.addRecipe(new DeconRecipe(result, ingredients, width, height, shapeless));
    }

    public boolean addRecipe(DeconRecipe recipe) {
        return recipeMap.put((Object)recipe.getResult().func_77977_a(), (Object)recipe);
    }

    public List<DeconRecipe> getRecipes(ItemStack stack) {
        ArrayList<DeconRecipe> filter = new ArrayList<DeconRecipe>();
        if (stack != null && stack != ItemStack.field_190927_a) {
            ArrayList result = new ArrayList(recipeMap.get((Object)stack.func_77977_a()));
            for (DeconRecipe recipe : result) {
                if (recipe.getResult().func_190916_E() > stack.func_190916_E() || recipe.getResult().func_77960_j() != stack.func_77960_j() || recipe == null || recipe.getIngredients() == null || Arrays.asList(recipe.getIngredients()).contains(recipe.getResult())) continue;
                filter.add(recipe);
            }
        }
        filter.sort((o1, o2) -> {
            String s1 = Arrays.stream(o1.getIngredients()).map(ItemStack::func_82833_r).collect(Collectors.toList()).toString();
            String s2 = Arrays.stream(o2.getIngredients()).map(ItemStack::func_82833_r).collect(Collectors.toList()).toString();
            return s1.compareTo(s2);
        });
        return filter;
    }
}

