/*
 * Decompiled with CFR 0.152.
 */
package deconstruction.common.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class DeconRecipe {
    private ItemStack result;
    private ItemStack[] ingredients;
    public boolean shapeless;
    public int size;
    public int width;
    public int height;

    public DeconRecipe(ItemStack result, ItemStack[] ingredients, int width, int height, boolean shapeless) {
        this.result = result;
        this.ingredients = ingredients;
        this.shapeless = shapeless;
        this.width = width;
        this.height = height;
        this.size = ingredients.length;
    }

    public DeconRecipe(IRecipe recipe) {
        this.width = this.size = recipe.func_192400_c().size();
        this.height = 1;
        if (recipe instanceof IShapedRecipe) {
            this.width = ((IShapedRecipe)recipe).getRecipeWidth();
            this.height = ((IShapedRecipe)recipe).getRecipeHeight();
        }
        this.result = recipe.func_77571_b();
        this.ingredients = this.normalizeItems(this.getFromList((NonNullList<Ingredient>)recipe.func_192400_c()));
        this.shapeless = recipe instanceof ShapelessRecipes || recipe instanceof ShapelessOreRecipe;
    }

    private ItemStack[] getFromList(NonNullList<Ingredient> recipeItems) {
        ItemStack[] toReturn = new ItemStack[recipeItems.size()];
        for (int i = 0; i < recipeItems.size(); ++i) {
            ItemStack stack = ItemStack.field_190927_a;
            try {
                ItemStack[] arr = ((Ingredient)recipeItems.get(i)).func_193365_a();
                if (arr.length != 0) {
                    stack = arr[0];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (stack == null) continue;
            toReturn[i] = stack.func_77946_l();
        }
        return toReturn;
    }

    public ItemStack getResult() {
        return this.result.func_77946_l();
    }

    public ItemStack[] getIngredients() {
        return this.copyItemStackArr(this.ingredients);
    }

    private ItemStack[] copyItemStackArr(ItemStack[] in) {
        if (in != null) {
            ItemStack[] out = new ItemStack[in.length];
            for (int i = 0; i < in.length; ++i) {
                out[i] = in[i] != null ? in[i].func_77946_l() : ItemStack.field_190927_a;
            }
            return out;
        }
        return null;
    }

    private ItemStack[] normalizeItems(ItemStack[] dirty) {
        if (dirty == null) {
            return new ItemStack[9];
        }
        ItemStack[] clean = new ItemStack[dirty.length];
        for (int i = 0; i < clean.length; ++i) {
            if (dirty[i] == null || dirty[i] == ItemStack.field_190927_a) continue;
            clean[i] = new ItemStack(dirty[i].func_77973_b(), 1, dirty[i].func_77952_i());
            if (clean[i].func_77952_i() == Short.MAX_VALUE) {
                clean[i].func_77964_b(0);
            }
            if (dirty[i].func_77973_b().getContainerItem(dirty[i]) == ItemStack.field_190927_a) continue;
            clean[i] = ItemStack.field_190927_a;
        }
        return clean;
    }

    private ItemStack[] convertOreDict(Object[] input) {
        try {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (Object o : input) {
                if (o != null) {
                    if (o instanceof ItemStack) {
                        list.add((ItemStack)o);
                        continue;
                    }
                    if (!(o instanceof List)) continue;
                    List l = (List)o;
                    Object o1 = l.get(0);
                    ItemStack stack = (ItemStack)o1;
                    list.add(stack.func_77946_l());
                    continue;
                }
                list.add(null);
            }
            return list.toArray(new ItemStack[list.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void nullify() {
        this.ingredients = null;
        this.result = null;
        this.width = -1;
        this.height = -1;
        this.size = -1;
    }
}

