/*
 * Decompiled with CFR 0.152.
 */
package deconstruction.common.gui;

import deconstruction.DeconTable;
import deconstruction.common.container.ContainerDeconTable;
import deconstruction.common.handler.DeconRecipe;
import deconstruction.common.handler.DeconstructionManager;
import deconstruction.common.network.PacketIndex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiDeconTable
extends GuiContainer {
    private static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("deconstruction", "textures/gui/deconstruction.png");
    private GuiButtonDecon next;
    private GuiButtonDecon back;
    public int recipeIndex = 0;
    private World world;
    private EntityPlayer player;

    public GuiDeconTable(EntityPlayer player, World worldIn) {
        this(player, worldIn, BlockPos.field_177992_a);
    }

    public GuiDeconTable(EntityPlayer player, World worldIn, BlockPos blockPosition) {
        super((Container)new ContainerDeconTable(player, worldIn, blockPosition));
        this.world = worldIn;
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.next = new GuiButtonDecon(1, x + 160, y + 53, true);
        this.field_146292_n.add(this.next);
        this.back = new GuiButtonDecon(2, x + 92, y + 53, false);
        this.field_146292_n.add(this.back);
        this.next.field_146124_l = false;
        this.back.field_146124_l = false;
        this.next.text = I18n.func_135052_a((String)"button.recipe.next", (Object[])new Object[0]);
        this.back.text = I18n.func_135052_a((String)"button.recipe.previous", (Object[])new Object[0]);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.deconstruction", (Object[])new Object[0]), 28, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CRAFTING_TABLE_GUI_TEXTURES);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73876_c() {
        super.func_73876_c();
        List<DeconRecipe> recipeList = DeconstructionManager.instance.getRecipes(this.player.field_71070_bA.func_75139_a(0).func_75211_c());
        if (recipeList.size() == 0) {
            this.recipeIndex = 0;
        }
        if (this.recipeIndex <= recipeList.size()) {
            this.next.field_146124_l = this.recipeIndex < recipeList.size() - 1;
            this.back.field_146124_l = this.recipeIndex > 0;
        } else {
            this.next.field_146124_l = false;
            this.back.field_146124_l = false;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float gameTicks) {
        super.func_73863_a(mouseX, mouseY, gameTicks);
        this.drawToolTips(mouseX, mouseY);
    }

    protected void drawToolTips(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        if (this.func_146978_c(162, 56, 10, 14, mouseX, mouseY)) {
            this.drawButtonTooltip(I18n.func_135052_a((String)"button.recipe.next", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (this.func_146978_c(94, 56, 10, 14, mouseX, mouseY)) {
            this.drawButtonTooltip(I18n.func_135052_a((String)"button.recipe.previous", (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void drawButtonTooltip(String name, int x, int y) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(name);
        this.drawTooltip(lines, x, y);
    }

    protected void drawTooltip(List<String> lines, int x, int y) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        int tooltipWidth = 0;
        for (String line1 : lines) {
            int tempWidth = this.field_146289_q.func_78256_a(line1);
            if (tempWidth <= tooltipWidth) continue;
            tooltipWidth = tempWidth;
        }
        int xStart = x + 12;
        int yStart = y - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            tooltipHeight += 2 + (lines.size() - 1) * 10;
        }
        if (this.field_147009_r + yStart + tooltipHeight + 6 > this.field_146295_m) {
            yStart = this.field_146295_m - tooltipHeight - this.field_147009_r - 6;
        }
        this.field_73735_i = 300.0f;
        this.field_146296_j.field_77023_b = 300.0f;
        int color1 = -267386864;
        this.func_73733_a(xStart - 3, yStart - 4, xStart + tooltipWidth + 3, yStart - 3, color1, color1);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 4, color1, color1);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart - 4, yStart - 3, xStart - 3, yStart + tooltipHeight + 3, color1, color1);
        this.func_73733_a(xStart + tooltipWidth + 3, yStart - 3, xStart + tooltipWidth + 4, yStart + tooltipHeight + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.func_73733_a(xStart - 3, yStart - 3 + 1, xStart - 3 + 1, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart + tooltipWidth + 2, yStart - 3 + 1, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3 - 1, color2, color3);
        this.func_73733_a(xStart - 3, yStart - 3, xStart + tooltipWidth + 3, yStart - 3 + 1, color2, color2);
        this.func_73733_a(xStart - 3, yStart + tooltipHeight + 2, xStart + tooltipWidth + 3, yStart + tooltipHeight + 3, color3, color3);
        for (int stringIndex = 0; stringIndex < lines.size(); ++stringIndex) {
            String line = lines.get(stringIndex);
            line = stringIndex == 0 ? "\u00a7" + Integer.toHexString(15) + line : "\u00a77" + line;
            this.field_146289_q.func_175063_a(line, (float)xStart, (float)yStart, -1);
            if (stringIndex == 0) {
                yStart += 2;
            }
            yStart += 10;
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2929);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_146284_a(GuiButton button) {
        boolean changed = false;
        if (button == this.next) {
            ++this.recipeIndex;
            changed = true;
        } else if (button == this.back) {
            --this.recipeIndex;
            changed = true;
        }
        if (changed && this.world.field_72995_K) {
            DeconTable.networkWrapper.sendToServer((IMessage)new PacketIndex(this.getRecipeIndex()));
            ((ContainerDeconTable)this.player.field_71070_bA).setRecipeIndex(this.getRecipeIndex());
        }
    }

    public int getRecipeIndex() {
        return this.recipeIndex;
    }

    public void setRecipeIndex(int recipeIndex) {
        this.recipeIndex = recipeIndex;
    }

    public class GuiButtonDecon
    extends GuiButton {
        private final boolean mirrored;
        public String text;
        private ResourceLocation guiTexture;

        public GuiButtonDecon(int buttonId, int x, int y, boolean mirrored) {
            super(buttonId, x, y, 12, 19, "");
            this.text = "";
            this.guiTexture = new ResourceLocation("deconstruction", "textures/gui/deconstruction.png");
            this.mirrored = mirrored;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(this.guiTexture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean mouseHovering = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int textureY = 0;
                int textureX = 176;
                if (!this.field_146124_l) {
                    textureX += 2 * this.field_146120_f;
                } else if (mouseHovering) {
                    textureX += this.field_146120_f;
                }
                if (!this.mirrored) {
                    textureY += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

