/*
 * Decompiled with CFR 0.152.
 */
package deconstruction;

import deconstruction.common.block.BlockDeconTable;
import deconstruction.common.command.CommandDeconTable;
import deconstruction.common.handler.DeconstructionManager;
import deconstruction.common.network.PacketIndex;
import deconstruction.proxy.Proxy;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="deconstruction", useMetadata=true, updateJSON="https://pastebin.com/raw/T1yNnPqG", acceptedMinecraftVersions="[1.12.2]")
public class DeconTable {
    public static final String NAME = "Deconstruction Table";
    public static final String MODID = "deconstruction";
    public static final BlockDeconTable BLOCK_DECON_TABLE = new BlockDeconTable();
    public static final ItemBlock ITEM_BLOCK_DECON_TABLE = new ItemBlock((Block)BLOCK_DECON_TABLE);
    public static Logger logger;
    public static SimpleNetworkWrapper networkWrapper;
    @Mod.Instance(value="deconstruction")
    public static DeconTable instance;
    @SidedProxy(clientSide="deconstruction.proxy.ClientProxy", serverSide="deconstruction.proxy.Proxy")
    public static Proxy proxy;

    public DeconTable() {
        instance = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        proxy.preInit();
        proxy.registerRenderers();
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("DeconTable");
        networkWrapper.registerMessage(PacketIndex.Handler.class, PacketIndex.class, 0, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        GameRegistry.addShapedRecipe((ResourceLocation)BLOCK_DECON_TABLE.getRegistryName(), null, (ItemStack)new ItemStack((Block)BLOCK_DECON_TABLE, 1), (Object[])new Object[]{"BDB", "ACA", "AAA", Character.valueOf('A'), Blocks.field_150344_f, Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('D'), Items.field_151045_i});
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        DeconTable.loadRecipes(null);
    }

    @Mod.EventHandler
    public void ServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDeconTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRecipes(ICommandSender player) {
        int fail = 0;
        DeconstructionManager.recipeMap.clear();
        ArrayList recipes = new ArrayList(ForgeRegistries.RECIPES.getValuesCollection());
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"DeconTable: Indexing Recipes", (int)recipes.size());
        for (IRecipe recipe : recipes) {
            String s = "null";
            try {
                if (recipe.func_77571_b() == ItemStack.field_190927_a) {
                    ++fail;
                    continue;
                }
                s = recipe.func_77571_b().func_82833_r();
                if (s == null) {
                    logger.warn("the recipe '" + recipe.getRegistryName() + "' is broken!");
                    throw new NullPointerException("ItemStack.getDisplayName cannot be null!");
                }
                DeconstructionManager.instance.addRecipe(recipe);
            }
            catch (NullPointerException e) {
                ++fail;
                logger.warn(e.getMessage());
                s = "null";
            }
            finally {
                progressBar.step(s);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        logger.info("done!");
        logger.info(fail + " invalid Recipes out of " + recipes.size());
        logger.info(DeconstructionManager.recipeMap.size() + " loaded out of " + (recipes.size() - fail) + " valid recipes.");
        if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentString(fail + " invalid Recipes out of " + recipes.size()));
            player.func_145747_a((ITextComponent)new TextComponentString(DeconstructionManager.recipeMap.size() + " loaded out of " + (recipes.size() - fail) + " valid recipes."));
        }
    }
}

