/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.handler;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageTeleportToWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HandlerTeleportToWaystone
implements IMessageHandler<MessageTeleportToWaystone, IMessage> {
    @Nullable
    public IMessage onMessage(MessageTeleportToWaystone message, MessageContext ctx) {
        NetworkHandler.getThreadListener(ctx).func_152344_a(() -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            TileWaystone tileWaystone = WaystoneManager.getWaystoneInWorld(message.getWaystone());
            boolean enableXPCost = WaystoneConfig.general.globalWaystonesCostXp || tileWaystone != null && !tileWaystone.isGlobal();
            int xpLevelCost = PlayerWaystoneHelper.getTravelCostByDistance((EntityPlayer)player, message.getWaystone());
            ItemStack heldItem = player.func_184586_b(message.getHand());
            switch (message.getWarpMode()) {
                case INVENTORY_BUTTON: {
                    if (!WaystoneConfig.general.teleportButton || WaystoneConfig.general.teleportButtonReturnOnly || !WaystoneConfig.general.teleportButtonTarget.isEmpty()) {
                        return;
                    }
                    boolean bl = enableXPCost = enableXPCost && WaystoneConfig.general.inventoryButtonXpCost && !player.field_71075_bZ.field_75098_d;
                    if (enableXPCost && player.field_71068_ca < xpLevelCost) {
                        return;
                    }
                    if (PlayerWaystoneHelper.canFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b)) break;
                    return;
                }
                case WARP_SCROLL: {
                    enableXPCost = false;
                    if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Waystones.itemWarpScroll) break;
                    return;
                }
                case WARP_STONE: {
                    boolean bl = enableXPCost = enableXPCost && WaystoneConfig.general.warpStoneXpCost && !player.field_71075_bZ.field_75098_d;
                    if (enableXPCost && player.field_71068_ca < xpLevelCost) {
                        return;
                    }
                    if (heldItem.func_190926_b() || heldItem.func_77973_b() != Waystones.itemWarpStone) {
                        return;
                    }
                    if (PlayerWaystoneHelper.canUseWarpStone((EntityPlayer)player)) break;
                    return;
                }
                case WAYSTONE: {
                    boolean bl = enableXPCost = enableXPCost && WaystoneConfig.general.waystoneXpCost && !player.field_71075_bZ.field_75098_d;
                    if (enableXPCost && player.field_71068_ca < xpLevelCost) {
                        return;
                    }
                    WaystoneEntry fromWaystone = message.getFromWaystone();
                    if (fromWaystone != null && WaystoneManager.getWaystoneInWorld(fromWaystone) != null) break;
                    return;
                }
            }
            if (WaystoneManager.teleportToWaystone((EntityPlayer)ctx.getServerHandler().field_147369_b, message.getWaystone())) {
                if (enableXPCost) {
                    player.func_82242_a(-xpLevelCost);
                }
                boolean shouldCooldown = !message.getWaystone().isGlobal() || !WaystoneConfig.general.globalNoCooldown;
                switch (message.getWarpMode()) {
                    case INVENTORY_BUTTON: {
                        if (!shouldCooldown) break;
                        PlayerWaystoneHelper.setLastFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b, System.currentTimeMillis());
                        break;
                    }
                    case WARP_SCROLL: {
                        heldItem.func_190918_g(1);
                        break;
                    }
                    case WARP_STONE: {
                        if (!shouldCooldown) break;
                        PlayerWaystoneHelper.setLastWarpStoneUse((EntityPlayer)ctx.getServerHandler().field_147369_b, System.currentTimeMillis());
                        break;
                    }
                }
            }
            WaystoneManager.sendPlayerWaystones((EntityPlayer)ctx.getServerHandler().field_147369_b);
        });
        return null;
    }
}

