/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.field;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import wanion.lib.common.IController;
import wanion.lib.common.ICopyable;
import wanion.lib.common.INBTMessage;
import wanion.lib.common.WContainer;
import wanion.lib.common.field.IField;
import wanion.lib.network.NetworkHelper;

public class FieldController
implements IController<FieldController, IField<?>>,
ICopyable<FieldController>,
INBTMessage {
    private final Map<String, IField<?>> fieldControlMap = new THashMap();
    private final Collection<IField<?>> values = this.fieldControlMap.values();
    private final IInventory inventory;

    public FieldController(@Nonnull IInventory inventory) {
        this.inventory = inventory;
    }

    public FieldController(@Nonnull IInventory inventory, IField<?> ... fields) {
        this(inventory);
        this.add(fields);
    }

    public FieldController(@Nonnull IInventory inventory, @Nonnull List<IField<?>> fieldList) {
        this(inventory);
        fieldList.forEach(xva$0 -> this.add((IField<?>)xva$0));
    }

    public FieldController(@Nonnull IInventory inventory, @Nonnull Map<String, IField<?>> fieldMap) {
        this(inventory);
        this.fieldControlMap.putAll(fieldMap);
    }

    public void add(IField<?> ... fields) {
        for (IField<?> field : fields) {
            this.fieldControlMap.put(field.getFieldName(), field);
        }
    }

    public Collection<IField<?>> getInstances() {
        return this.values;
    }

    public IField<?> getField(@Nonnull String name) {
        return this.fieldControlMap.get(name);
    }

    @Override
    @Nonnull
    public List<IField<?>> compareContents(@Nonnull FieldController otherFieldController) {
        ArrayList differences = new ArrayList();
        for (IField<?> field : this.values) {
            IField<?> otherField;
            if (field.equals(otherField = otherFieldController.fieldControlMap.get(field.getFieldName()))) continue;
            differences.add(field);
        }
        return differences;
    }

    @Override
    public void addListener(int windowId, @Nonnull WContainer<?> wContainer, @Nonnull EntityPlayerMP entityPlayerMP) {
        NetworkHelper.addFieldListener(windowId, wContainer, entityPlayerMP);
    }

    @Override
    public void detectAndSendChanges(int windowId, @Nonnull WContainer<?> wContainer) {
        NetworkHelper.detectAndSendFieldChanges(windowId, wContainer);
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound fieldNBT = new NBTTagCompound();
        NBTTagList fieldTagList = new NBTTagList();
        fieldNBT.func_74782_a("field", (NBTBase)fieldTagList);
        this.values.forEach(field -> fieldTagList.func_74742_a((NBTBase)field.writeNBT()));
        return fieldNBT;
    }

    @Override
    public void afterWriteNBT(@Nonnull NBTTagCompound smartNBT) {
        NBTTagList fieldTagList = smartNBT.func_150295_c("field", 10);
        if (fieldTagList.func_82582_d()) {
            return;
        }
        for (int i = 0; i < fieldTagList.func_74745_c(); ++i) {
            NBTTagCompound fieldTag = fieldTagList.func_150305_b(i);
            IField<?> field = this.fieldControlMap.get(fieldTag.func_74779_i("fieldName"));
            if (field == null) continue;
            field.afterWriteNBT(fieldTag);
        }
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound smartNBT) {
        NBTTagList fieldTagList = smartNBT.func_150295_c("field", 10);
        if (fieldTagList.func_82582_d()) {
            return;
        }
        for (int i = 0; i < fieldTagList.func_74745_c(); ++i) {
            NBTTagCompound fieldTag = fieldTagList.func_150305_b(i);
            IField<?> field = this.fieldControlMap.get(fieldTag.func_74779_i("fieldName"));
            if (field == null) continue;
            field.readNBT(fieldTag);
        }
        this.inventory.func_70296_d();
    }

    @Override
    @Nonnull
    public FieldController copy() {
        return new FieldController(this.inventory, this.values.stream().map(ICopyable::copy).collect(Collectors.toList()));
    }

    @Override
    public void receiveNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        IField<?> field;
        String fieldName = nbtTagCompound.func_74764_b("fieldName") ? nbtTagCompound.func_74779_i("fieldName") : null;
        IField<?> iField = field = fieldName != null ? this.fieldControlMap.get(fieldName) : null;
        if (field != null) {
            field.receiveNBT(nbtTagCompound);
            this.inventory.func_70296_d();
        }
    }
}

