/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.ItemStackMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.client.gui.GuiAbilityContainer;
import org.cyclops.everlastingabilities.inventory.container.ContainerAbilityContainer;

public abstract class ItemGuiAbilityContainer
extends ItemGui {
    protected ItemGuiAbilityContainer(ExtendedConfig eConfig) {
        super(eConfig);
        this.func_77625_d(1);
    }

    public Class<? extends Container> getContainer() {
        return ContainerAbilityContainer.class;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GuiScreen> getGui() {
        return GuiAbilityContainer.class;
    }

    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        IAbilityStore abilityStore = (IAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
        ArrayList<Ability> abilities = new ArrayList<Ability>(abilityStore.getAbilities());
        Collections.sort(abilities);
        boolean empty = true;
        for (Ability ability : abilities) {
            empty = false;
            String name = L10NHelpers.localize((String)ability.getAbilityType().getTranslationKey(), (Object[])new Object[0]);
            list.add(TextFormatting.YELLOW + name + ": " + TextFormatting.RESET + ability.getLevel());
        }
        if (empty) {
            list.add(TextFormatting.GRAY.toString() + TextFormatting.ITALIC + L10NHelpers.localize((String)"general.everlastingabilities.empty", (Object[])new Object[0]));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new DefaultCapabilityProvider(MutableAbilityStoreConfig.CAPABILITY, (Object)new ItemStackMutableAbilityStore(stack));
    }

    public abstract boolean canMoveFromPlayer();

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.func_77973_b() != newStack.func_77973_b();
    }
}

