/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.inventory.container;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProviderConfigurable;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.client.gui.GuiAbilityContainer;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;

public class ContainerAbilityContainer
extends ItemInventoryContainer<ItemGuiAbilityContainer> {
    @SideOnly(value=Side.CLIENT)
    private GuiAbilityContainer gui;

    public ContainerAbilityContainer(EntityPlayer player, int itemIndex, EnumHand hand) {
        super(player.field_71071_by, (Item)((ItemGuiAbilityContainer)InventoryHelpers.getItemFromIndex((EntityPlayer)player, (int)itemIndex, (EnumHand)hand).func_77973_b()), itemIndex, hand);
        this.addInventory((IInventory)player.field_71071_by, 0, 8, 195, 1, 9);
        int level = AbilityHelpers.getLevelForExperience(player.field_71067_cb);
        if (player.field_71068_ca != level) {
            player.field_71067_cb = AbilityHelpers.getExperienceForLevel(player.field_71068_ca);
        }
    }

    public IGuiContainerProviderConfigurable getGuiProvider() {
        return ItemAbilityTotem.getInstance();
    }

    @SideOnly(value=Side.CLIENT)
    public void setGui(GuiAbilityContainer gui) {
        this.gui = gui;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiAbilityContainer getGui() {
        return this.gui;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public IMutableAbilityStore getPlayerAbilityStore() {
        return (IMutableAbilityStore)this.player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
    }

    public IMutableAbilityStore getItemAbilityStore() {
        ItemStack itemStack = this.getItemStack(this.player);
        if (itemStack == null) {
            return null;
        }
        return (IMutableAbilityStore)itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
    }

    @Nullable
    public List<Ability> getPlayerAbilities() {
        IMutableAbilityStore abilityStore = this.getPlayerAbilityStore();
        if (abilityStore == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(abilityStore.getAbilities());
    }

    public List<Ability> getItemAbilities() {
        IMutableAbilityStore abilityStore = this.getItemAbilityStore();
        if (abilityStore == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(abilityStore.getAbilities());
    }

    public void moveFromPlayer(Ability playerAbility) {
        Ability insertedAbility = AbilityHelpers.insert(playerAbility, this.getItemAbilityStore());
        if (insertedAbility != null) {
            AbilityHelpers.removePlayerAbility(this.player, insertedAbility, true, true);
        }
    }

    public void moveToPlayer(Ability itemAbility) {
        Ability insertedAbility = AbilityHelpers.addPlayerAbility(this.player, itemAbility, true, true);
        if (insertedAbility != null) {
            AbilityHelpers.extract(insertedAbility, this.getItemAbilityStore());
            if (this.getItemAbilities().isEmpty() && !((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer()) {
                InventoryHelpers.setItemAtIndex((EntityPlayer)this.player, (int)this.itemIndex, (EnumHand)this.hand, (ItemStack)ItemStack.field_190927_a);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.getItemStack(player) != null && (((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer() || !this.getItemAbilities().isEmpty());
    }
}

