/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.DefaultMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;

public class ItemStackMutableAbilityStore
implements IMutableAbilityStore {
    private static final String NBT_STORE = "everlastingabilities:abilityStoreStack";
    private final ItemStack itemStack;

    public ItemStackMutableAbilityStore(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    protected IMutableAbilityStore getInnerStore() {
        DefaultMutableAbilityStore store = new DefaultMutableAbilityStore();
        NBTTagCompound root = ItemStackHelpers.getSafeTagCompound((ItemStack)this.itemStack);
        if (!root.func_74764_b(NBT_STORE)) {
            root.func_74782_a(NBT_STORE, (NBTBase)new NBTTagList());
        }
        NBTBase nbt = root.func_74781_a(NBT_STORE);
        MutableAbilityStoreConfig.CAPABILITY.readNBT((Object)store, null, nbt);
        return store;
    }

    protected IMutableAbilityStore setInnerStore(IMutableAbilityStore store) {
        NBTTagCompound root = ItemStackHelpers.getSafeTagCompound((ItemStack)this.itemStack);
        NBTBase nbt = MutableAbilityStoreConfig.CAPABILITY.writeNBT((Object)store, null);
        root.func_74782_a(NBT_STORE, nbt);
        return store;
    }

    @Override
    @Nullable
    public Ability addAbility(Ability ability, boolean doAdd) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.addAbility(ability, doAdd);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    @Nullable
    public Ability removeAbility(Ability ability, boolean doRemove) {
        IMutableAbilityStore store = this.getInnerStore();
        Ability ret = store.removeAbility(ability, doRemove);
        this.setInnerStore(store);
        return ret;
    }

    @Override
    public void setAbilities(Map<IAbilityType, Integer> abilityTypes) {
        IMutableAbilityStore store = this.getInnerStore();
        store.setAbilities(abilityTypes);
        this.setInnerStore(store);
    }

    @Override
    public boolean hasAbilityType(IAbilityType abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.hasAbilityType(abilityType);
    }

    @Override
    public Collection<IAbilityType> getAbilityTypes() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilityTypes();
    }

    @Override
    public Collection<Ability> getAbilities() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilities();
    }

    @Override
    public Map<IAbilityType, Integer> getAbilitiesRaw() {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbilitiesRaw();
    }

    @Override
    public Ability getAbility(IAbilityType abilityType) {
        IMutableAbilityStore store = this.getInnerStore();
        return store.getAbility(abilityType);
    }
}

