/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api.capability;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.ability.AbilityTypes;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;

public class AbilityStoreStorage
implements Capability.IStorage<IAbilityStore> {
    public NBTBase writeNBT(Capability<IAbilityStore> capability, IAbilityStore instance, EnumFacing side) {
        NBTTagList list = new NBTTagList();
        for (Ability ability : instance.getAbilities()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", ability.getAbilityType().getTranslationKey());
            tag.func_74768_a("level", ability.getLevel());
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public void readNBT(Capability<IAbilityStore> capability, IAbilityStore instance, EnumFacing side, NBTBase nbt) {
        HashMap abilityTypes = Maps.newHashMap();
        if (nbt instanceof NBTTagList) {
            if (((NBTTagList)nbt).func_150303_d() == MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal()) {
                NBTTagList list = (NBTTagList)nbt;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    String unlocalizedName = tag.func_74779_i("name");
                    int level = tag.func_74762_e("level");
                    IAbilityType abilityType = AbilityTypes.REGISTRY.getAbilityType(unlocalizedName);
                    if (abilityType == null) continue;
                    abilityTypes.put(abilityType, level);
                }
            }
        } else {
            EverlastingAbilities.clog(Level.WARN, "Resetting a corrupted ability storage.");
        }
        instance.setAbilities(abilityTypes);
    }
}

