/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.CreativeCore;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.CreativeMessageHandler;
import com.creativemd.creativecore.common.packet.CreativeSplittedMessageHandler;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketHandler {
    private static ArrayList<CreativeSplittedMessageHandler> queuedMessages = new ArrayList();

    public static void addQueueMessage(CreativeSplittedMessageHandler message) {
        queuedMessages.add(message);
    }

    private static void sendQueuedMessage(EntityPlayer player) {
        for (int i = 0; i < queuedMessages.size(); ++i) {
            PacketHandler.sendMessage(PacketHandler.queuedMessages.get((int)i).type, player, queuedMessages.get(i));
        }
        queuedMessages.clear();
    }

    public static void sendMessage(CreativeMessageHandler.MessageType type, EntityPlayer player, IMessage message) {
        switch (type) {
            case ToAllPlayer: {
                CreativeCore.network.sendToAll(message);
                break;
            }
            case ToPlayer: {
                CreativeCore.network.sendTo(message, (EntityPlayerMP)player);
                break;
            }
            case ToServer: {
                CreativeCore.network.sendToServer(message);
            }
        }
    }

    public static void sendPacketToAllPlayers(CreativeCorePacket packet) {
        CreativeCore.network.sendToAll((IMessage)new CreativeMessageHandler(packet, CreativeMessageHandler.MessageType.ToAllPlayer, null));
        PacketHandler.sendQueuedMessage(null);
    }

    public static void sendPacketToServer(CreativeCorePacket packet) {
        CreativeCore.network.sendToServer((IMessage)new CreativeMessageHandler(packet, CreativeMessageHandler.MessageType.ToServer, null));
        PacketHandler.sendQueuedMessage(null);
    }

    public static void sendPacketsToAllPlayers(List<CreativeCorePacket> packets) {
        for (int i = 0; i < packets.size(); ++i) {
            PacketHandler.sendPacketToAllPlayers(packets.get(i));
        }
    }

    public static void sendPacketToNearPlayers(World world, CreativeCorePacket packet, final int distance, final BlockPos pos) {
        for (EntityPlayerMP entityplayermp : world.func_175661_b(EntityPlayerMP.class, (Predicate)new Predicate<EntityPlayerMP>(){

            public boolean apply(@Nullable EntityPlayerMP p_apply_1_) {
                return p_apply_1_.func_174818_b(pos) < Math.pow(distance, 2.0);
            }
        })) {
            PacketHandler.sendPacketToPlayer(packet, entityplayermp);
        }
    }

    public static void sendPacketToPlayer(CreativeCorePacket packet, EntityPlayerMP player) {
        CreativeCore.network.sendTo((IMessage)new CreativeMessageHandler(packet, CreativeMessageHandler.MessageType.ToPlayer, (EntityPlayer)player), player);
        PacketHandler.sendQueuedMessage((EntityPlayer)player);
    }

    public static void sendPacketToPlayers(CreativeCorePacket packet, Iterable<? extends EntityPlayer> players) {
        for (EntityPlayer entityPlayer : players) {
            PacketHandler.sendPacketToPlayer(packet, (EntityPlayerMP)entityPlayer);
        }
    }

    public static void sendPacketToPlayers(CreativeCorePacket packet, Iterable<? extends EntityPlayer> players, @Nullable Predicate<EntityPlayer> predicate) {
        for (EntityPlayer entityPlayer : players) {
            if (predicate != null && !predicate.apply((Object)entityPlayer)) continue;
            PacketHandler.sendPacketToPlayer(packet, (EntityPlayerMP)entityPlayer);
        }
    }

    private static CreativeWorld getParentSubWorld(IOrientatedWorld world) {
        if (world.getParent() instanceof IOrientatedWorld) {
            return PacketHandler.getParentSubWorld((IOrientatedWorld)world.getParent());
        }
        return (CreativeWorld)world;
    }

    public static void sendPacketToTrackingPlayers(CreativeCorePacket packet, World world, BlockPos pos, @Nullable Predicate<EntityPlayer> predicate) {
        if (world instanceof IOrientatedWorld) {
            CreativeWorld subWorld = PacketHandler.getParentSubWorld((IOrientatedWorld)world);
            PacketHandler.sendPacketToTrackingPlayers(packet, subWorld.parent, (WorldServer)((IOrientatedWorld)world).getRealWorld(), predicate);
        } else {
            PacketHandler.sendPacketToPlayers(packet, ((WorldServer)world).func_184164_w().func_187301_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).getWatchingPlayers(), predicate);
        }
    }

    public static void sendPacketToTrackingPlayers(CreativeCorePacket packet, Entity entity, WorldServer world, @Nullable Predicate<EntityPlayer> predicate) {
        for (EntityPlayer player : world.func_73039_n().getTrackingPlayers(entity)) {
            if (predicate != null && !predicate.apply((Object)player)) continue;
            PacketHandler.sendPacketToPlayer(packet, (EntityPlayerMP)player);
        }
    }

    public static void sendPacketToTrackingPlayers(CreativeCorePacket packet, EntityPlayerMP player) {
        Set players = player.func_71121_q().func_73039_n().getTrackingPlayers((Entity)player);
        for (EntityPlayer entityPlayer : players) {
            PacketHandler.sendPacketToPlayer(packet, (EntityPlayerMP)entityPlayer);
        }
    }
}

