/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs;

import crafttweaker.CraftTweakerAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.badmobs.addons.crt.BadMobsTweaker;
import net.darkhax.badmobs.handler.ClientEventHandler;
import net.darkhax.badmobs.handler.ConfigurationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="badmobs", name="Bad Mobs", version="1.1.40", acceptableRemoteVersions="*", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class BadMobs {
    public static final List<String> GLOBAL_BLACKLIST = new ArrayList<String>();
    public static final Map<Integer, List<String>> DIMENSIONAL_BLACKLIST = new HashMap<Integer, List<String>>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent pre) {
        new ConfigurationHandler(pre.getSuggestedConfigurationFile());
        if (pre.getSide() == Side.CLIENT && ConfigurationHandler.addIDToTooltip) {
            MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        }
        if (Loader.isModLoaded((String)"crafttweaker")) {
            CraftTweakerAPI.registerClass(BadMobsTweaker.class);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            for (EnumCreatureType type : EnumCreatureType.values()) {
                biome.func_76747_a(type).removeIf(entry -> BadMobs.isBlacklisted(entry.field_76300_b));
            }
        }
    }

    public static void blacklist(String entity) {
        GLOBAL_BLACKLIST.add(entity);
    }

    public static void remove(String entity) {
        GLOBAL_BLACKLIST.remove(entity);
    }

    public static void blacklist(int id, String entity) {
        if (!DIMENSIONAL_BLACKLIST.containsKey(id)) {
            DIMENSIONAL_BLACKLIST.put(id, new ArrayList());
        }
        DIMENSIONAL_BLACKLIST.get(id).add(entity);
    }

    public static void remove(int id, String entity) {
        if (!DIMENSIONAL_BLACKLIST.containsKey(id)) {
            DIMENSIONAL_BLACKLIST.put(id, new ArrayList());
        }
        DIMENSIONAL_BLACKLIST.get(id).remove(entity);
    }

    public static boolean isBlacklisted(Class<? extends Entity> entClass) {
        ResourceLocation id = EntityList.func_191306_a(entClass);
        String entityId = id != null ? id.toString() : null;
        return GLOBAL_BLACKLIST.contains(entityId);
    }

    public static boolean isBlacklisted(Entity entity) {
        String entityId;
        ResourceLocation id = EntityList.func_191301_a((Entity)entity);
        String string = entityId = id != null ? id.toString() : null;
        return GLOBAL_BLACKLIST.contains(entityId) ? true : (DIMENSIONAL_BLACKLIST.get(entity.field_71093_bK) != null ? DIMENSIONAL_BLACKLIST.get(entity.field_71093_bK).contains(entityId) : false);
    }
}

