/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.collect.Iterators;
import com.google.common.math.DoubleMath;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.common.util.CommonUtils;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ISpecialArmor;

public class ArmorUtils {
    public static double getArmor(ItemStack stack, EntityEquipmentSlot slot) {
        return ArmorUtils.getValueFromAttributes(SharedMonsterAttributes.field_188791_g, slot, stack);
    }

    public static double getArmorThoughness(ItemStack stack, EntityEquipmentSlot slot) {
        return ArmorUtils.getValueFromAttributes(SharedMonsterAttributes.field_189429_h, slot, stack);
    }

    public static double applyArmorModifier(EntityEquipmentSlot slot, double rawArmor) {
        if (rawArmor <= 0.0) {
            return 0.0;
        }
        rawArmor *= ArmorUtils.getArmorModifier(slot);
        if (slot == EntityEquipmentSlot.HEAD) {
            rawArmor += 1.0;
        }
        return rawArmor;
    }

    public static double applyToughnessModifier(EntityEquipmentSlot slot, double rawToughness) {
        if (rawToughness <= 0.0) {
            return 0.0;
        }
        return rawToughness *= ArmorUtils.getToughnessModifier(slot);
    }

    private static double getArmorModifier(EntityEquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return 2.5;
            }
            case LEGS: {
                return 3.0;
            }
            case FEET: 
            case HEAD: {
                return 6.0;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getToughnessModifier(EntityEquipmentSlot slot) {
        switch (slot) {
            case CHEST: 
            case LEGS: {
                return 3.0;
            }
            case FEET: {
                return 3.5;
            }
            case HEAD: {
                return 4.0;
            }
        }
        throw new IllegalArgumentException("Invalid slot " + slot);
    }

    private static double getValueFromAttributes(IAttribute attribute, EntityEquipmentSlot slot, ItemStack stack) {
        return stack.func_77973_b().getAttributeModifiers(slot, stack).get((Object)attribute.func_111108_a()).stream().mapToDouble(AttributeModifier::func_111164_d).sum();
    }

    private static double getGlobalRestAttribute(EntityPlayer player, IAttribute attribute) {
        double sumOfAllAttributes = 0.0;
        for (EntityEquipmentSlot slot : CommonUtils.ARMOR_SLOTS) {
            ItemStack otherStack = player.func_184582_a(slot);
            sumOfAllAttributes += ArmorUtils.getValueFromAttributes(attribute, slot, otherStack);
        }
        double all = player.func_110148_a(attribute).func_111126_e();
        if (!DoubleMath.fuzzyEquals((double)sumOfAllAttributes, (double)all, (double)0.001)) {
            double diff = all - sumOfAllAttributes;
            if (FirstAidConfig.debug) {
                FirstAid.LOGGER.info("Attribute value for {} does not match sum! Diff is {}, distributing to all!", (Object)attribute.func_111108_a(), (Object)diff);
            }
            return diff;
        }
        return 0.0;
    }

    public static float applyArmor(@Nonnull EntityPlayer entity, @Nonnull ItemStack itemStack, @Nonnull DamageSource source, double damage, @Nonnull EntityEquipmentSlot slot) {
        ISpecialArmor armor;
        NonNullList inventory = entity.field_71071_by.field_70460_b;
        double totalArmor = 0.0;
        double totalToughness = 0.0;
        Item item = itemStack.func_77973_b();
        ISpecialArmor.ArmorProperties prop = null;
        boolean unblockable = source.func_76363_c();
        if (unblockable && item instanceof ISpecialArmor) {
            unblockable = ((ISpecialArmor)item).handleUnblockableDamage((EntityLivingBase)entity, itemStack, source, damage, slot.func_188454_b());
        }
        if (unblockable) {
            return (float)damage;
        }
        if (item instanceof ISpecialArmor) {
            armor = (ISpecialArmor)item;
            prop = armor.getProperties((EntityLivingBase)entity, itemStack, source, damage, slot.func_188454_b()).copy();
            totalArmor += prop.Armor;
            totalToughness += prop.Toughness;
        } else if (item instanceof ItemArmor) {
            armor = (ItemArmor)item;
            prop = new ISpecialArmor.ArmorProperties(0, 0.0, Integer.MAX_VALUE);
            prop.Armor = armor.field_77879_b;
            prop.Toughness = armor.field_189415_e;
        }
        if (item instanceof ItemArmor) {
            totalArmor += ArmorUtils.getArmor(itemStack, slot);
            totalToughness += ArmorUtils.getArmorThoughness(itemStack, slot);
        }
        if (prop != null) {
            totalArmor = ArmorUtils.applyArmorModifier(slot, totalArmor);
            totalToughness = ArmorUtils.applyToughnessModifier(slot, totalToughness);
            prop.Slot = slot.func_188454_b();
            double ratio = prop.AbsorbRatio * ArmorUtils.getArmorModifier(slot);
            double absorb = damage * ratio;
            if (absorb > 0.0) {
                ItemStack stack = (ItemStack)inventory.get(prop.Slot);
                int itemDamage = (int)Math.max(1.0, absorb);
                if (stack.func_77973_b() instanceof ISpecialArmor) {
                    ((ISpecialArmor)stack.func_77973_b()).damageArmor((EntityLivingBase)entity, stack, source, itemDamage, prop.Slot);
                } else {
                    stack.func_77972_a(itemDamage, (EntityLivingBase)entity);
                }
            }
            damage -= damage * ratio;
        }
        totalArmor += ArmorUtils.getGlobalRestAttribute(entity, SharedMonsterAttributes.field_188791_g);
        totalToughness += ArmorUtils.getGlobalRestAttribute(entity, SharedMonsterAttributes.field_189429_h);
        if (damage > 0.0 && (totalArmor > 0.0 || totalToughness > 0.0)) {
            double armorDamage = Math.max(1.0, damage);
            if (item instanceof ItemArmor) {
                itemStack.func_77972_a((int)armorDamage, (EntityLivingBase)entity);
            }
            damage = CombatRules.func_189427_a((float)((float)damage), (float)((float)totalArmor), (float)((float)totalToughness));
        }
        return (float)damage;
    }

    public static float applyGlobalPotionModifiers(EntityPlayer player, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (player.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        return damage;
    }

    public static float applyEnchantmentModifiers(EntityPlayer player, EntityEquipmentSlot slot, DamageSource source, float damage) {
        int k;
        if (source.func_151517_h()) {
            return damage;
        }
        if (FirstAidConfig.armorEnchantmentMode == FirstAidConfig.ArmorEnchantmentMode.LOCAL_ENCHANTMENTS) {
            k = EnchantmentHelper.func_77508_a(() -> Iterators.singletonIterator((Object)player.func_184582_a(slot)), (DamageSource)source);
            k *= 4;
        } else if (FirstAidConfig.armorEnchantmentMode == FirstAidConfig.ArmorEnchantmentMode.GLOBAL_ENCHANTMENTS) {
            k = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)source);
        } else {
            throw new RuntimeException("What dark magic is " + (Object)((Object)FirstAidConfig.armorEnchantmentMode));
        }
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }
}

