/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageApplyHealingItem
implements IMessage {
    private EnumPlayerPart part;
    private EnumHand hand;

    public MessageApplyHealingItem() {
    }

    public MessageApplyHealingItem(EnumPlayerPart part, EnumHand hand) {
        this.part = part;
        this.hand = hand;
    }

    public void fromBytes(ByteBuf buf) {
        this.part = EnumPlayerPart.fromID(buf.readByte());
        this.hand = buf.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.part.id);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
    }

    public static class Handler
    implements IMessageHandler<MessageApplyHealingItem, IMessage> {
        public IMessage onMessage(MessageApplyHealingItem message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
                ItemStack stack = player.func_184586_b(message.hand);
                Item item = stack.func_77973_b();
                AbstractPartHealer healer = FirstAidRegistryImpl.INSTANCE.getPartHealer(stack);
                if (healer == null) {
                    FirstAid.LOGGER.warn("Player {} has invalid item in hand {} while it should be an healing item", (Object)player.func_70005_c_(), (Object)item.getRegistryName());
                    player.func_145747_a((ITextComponent)new TextComponentString("Unable to apply healing item!"));
                    return;
                }
                stack.func_190918_g(1);
                AbstractDamageablePart damageablePart = damageModel.getFromEnum(message.part);
                damageablePart.activeHealer = healer;
            });
            return null;
        }
    }
}

