/*
 * Decompiled with CFR 0.152.
 */
package eu.keray.swarm;

import eu.keray.swarm.Config;
import eu.keray.swarm.ObjPool;
import eu.keray.swarm.SwarmWorld;
import eu.keray.swarm.ValueMap;
import eu.keray.swarm.Vec3I;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import swarm.api.SwarmControl;

public class SwarmWorldDiggerBase {
    static final Block web = Blocks.field_150321_G;
    protected final SwarmWorld sw;
    protected Block bridge = Blocks.field_150351_n;
    protected final ObjPool<Vec3I> vecpool = new ObjPool<Vec3I>(Vec3I.class);
    private final ValueMap<Vec3I> damaged = new ValueMap(2048);
    private static final float minimum = 0.26f;
    Map<EntityCreature, Mob> mobs = new HashMap<EntityCreature, Mob>();

    public SwarmWorldDiggerBase(SwarmWorld sw) {
        this.sw = sw;
    }

    public boolean damage(Vec3I loc, int damage) {
        return this.damage(loc.x, loc.y, loc.z, damage);
    }

    public boolean damage(int x, int y, int z, int damage) {
        SoundEvent s;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.sw.world.func_180495_p(pos);
        Block type = state.func_177230_c();
        if (type == Blocks.field_150350_a || type == null) {
            return true;
        }
        int maxdamage = this.getMatDmg(type, x, y, z);
        if (maxdamage < 0) {
            return false;
        }
        if (!SwarmControl.instance.canSwarmBreakBlock((World)this.sw.world, x, y, z)) {
            return false;
        }
        if (maxdamage == 0) {
            if (state.func_185904_a() == Material.field_151592_s) {
                this.sw.world.func_184134_a((double)x, (double)y, (double)z, new SoundEvent(new ResourceLocation("dig.glass")), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
            type.func_180653_a((World)this.sw.world, pos, state, 1.0f, 0);
            this.sw.world.func_175698_g(pos);
            return true;
        }
        if (this.damaged.size() >= 2048) {
            return false;
        }
        Vec3I loc = new Vec3I(x, y, z);
        if ((damage = this.damaged.increment(loc, damage) + damage) >= maxdamage) {
            this.damaged.remove(loc, 0);
            type.func_180663_b((World)this.sw.world, pos, state);
            type.func_180653_a((World)this.sw.world, pos, state, 1.0f, 0);
            this.sw.world.func_175698_g(pos);
            if (state.func_185904_a() == Material.field_151592_s) {
                this.sw.world.func_184134_a((double)x, (double)y, (double)z, new SoundEvent(new ResourceLocation("dig.glass")), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
            return true;
        }
        SoundEvent sound = null;
        if (type.func_185467_w() != null && (s = type.func_185467_w().func_185846_f()) != null) {
            sound = s;
        }
        if (sound == null) {
            sound = new SoundEvent(new ResourceLocation("dig.stone"));
        }
        this.sw.world.func_184134_a((double)x, (double)y, (double)z, sound, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        if (type == Blocks.field_150417_aV && state.func_177229_b((IProperty)BlockStoneBrick.field_176249_a) == BlockStoneBrick.EnumType.DEFAULT && damage > maxdamage / 2) {
            this.sw.world.func_180501_a(pos, state.func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED), 2);
        }
        return false;
    }

    protected int getMatDmg(Block type, int x, int y, int z) {
        float res = type.func_149638_a(null) * Config.RESISTANCE_MULTIPLIER;
        if (res < 0.26f) {
            return 0;
        }
        if (res > Config.MAX_RES) {
            res = Config.MAX_RES;
        }
        return Math.max(2, (int)(res * 2.5f));
    }

    public boolean bridge(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        Chunk chk = this.sw.world.func_175726_f(pos);
        if (chk == null || !chk.func_177410_o()) {
            return false;
        }
        if (!SwarmControl.instance.canSwarmPlaceBlock((World)this.sw.world, x, y, z)) {
            return false;
        }
        IBlockState state = this.sw.world.func_180495_p(pos);
        Block type = state.func_177230_c();
        if (type != null && type != Blocks.field_150350_a) {
            type.func_180653_a((World)this.sw.world, pos, state, 1.0f, 0);
        }
        this.sw.world.func_180501_a(pos, this.bridge.func_176223_P(), 2);
        return true;
    }

    public boolean damageLights(Vec3I loc, int height) {
        if (loc.getLightBlocks((World)this.sw.world) < 8) {
            return false;
        }
        boolean damaged = false;
        for (int xs = -1; xs <= 1; ++xs) {
            for (int ys = 0; ys < height; ++ys) {
                for (int zs = -1; zs <= 1; ++zs) {
                    Vec3I rel = loc.getRelative(xs, ys, zs);
                    rel.getData((World)this.sw.world).getLightValue((IBlockAccess)this.sw.world, new BlockPos(rel.x, rel.y, rel.z));
                    if (rel.getData((World)this.sw.world).func_185906_d() <= 7) continue;
                    this.damage(rel, 1);
                    damaged = true;
                }
            }
        }
        return damaged;
    }

    public void update() {
        this.damaged.reduce(null);
        Iterator<Map.Entry<EntityCreature, Mob>> iter = this.mobs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<EntityCreature, Mob> next = iter.next();
            if (next.getKey().func_70089_S()) continue;
            iter.remove();
        }
    }

    public final boolean isFreePass(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState t = this.sw.world.func_180495_p(pos);
        if (t.func_185904_a().func_76224_d()) {
            // empty if block
        }
        return !t.func_185904_a().func_76230_c() && t.func_185904_a() != Material.field_151586_h;
    }

    public final boolean tryAttack(int x, int y, int z) {
        IBlockState state = this.sw.world.func_180495_p(new BlockPos(x, y, z));
        Block type = state.func_177230_c();
        if (type == null || type == Blocks.field_150350_a) {
            return false;
        }
        if (state.func_185904_a().func_76230_c() || type == web) {
            return !this.damage(x, y, z, 3);
        }
        return false;
    }

    public Mob getMob(EntityCreature ent) {
        Mob mob = this.mobs.get(ent);
        if (mob != null) {
            return mob;
        }
        mob = new Mob(ent);
        this.mobs.put(ent, mob);
        return mob;
    }

    class Mob {
        int time;
        int x;
        int y;
        int z;

        public Mob(EntityCreature ent) {
            this.set(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
        }

        public void set(double x, double y, double z) {
            this.x = (int)x;
            this.y = (int)y;
            this.z = (int)z;
        }

        public boolean isNear(Vec3I vec) {
            int dx = Math.abs(vec.x - this.x);
            int dy = Math.abs(vec.y - this.y);
            int dz = Math.abs(vec.z - this.z);
            return dx < 4 && dy < 3 && dz < 4;
        }

        public String toString() {
            return "mob[" + this.x + "," + this.y + "," + this.z + "]";
        }
    }
}

