/*
 * Decompiled with CFR 0.152.
 */
package eu.keray.swarm;

import eu.keray.swarm.Config;
import eu.keray.swarm.Log;
import eu.keray.swarm.Maths;
import eu.keray.swarm.MonsterSwarmMod;
import eu.keray.swarm.SwarmWorldDigger;
import eu.keray.swarm.Vec3D;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SwarmWorld {
    protected WorldServer world;
    private SwarmWorldDigger digg;
    public final List<EntityCreature> attackers = new ArrayList<EntityCreature>();
    public final List<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
    public boolean isOverworld = false;
    public boolean isNether = false;
    public boolean fullmoon = true;
    public boolean isDay = false;
    int index = 0;
    int ticks = 0;

    public boolean isSurface(Entity mob) {
        if (mob == null) {
            return false;
        }
        return this.isOverworld && mob.field_70163_u > 40.0;
    }

    public SwarmWorld(WorldServer world) {
        Log.log("Registering world dimension " + world.field_73011_w.getDimension());
        this.world = world;
        this.digg = new SwarmWorldDigger(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (world.field_73011_w.getDimension() == 0) {
            this.isOverworld = true;
        }
        if (world.field_73011_w.getDimension() == -1) {
            this.isNether = true;
        }
    }

    public void run() {
        ++this.ticks;
        if (this.isOverworld) {
            int time = (int)this.world.func_72820_D() % 24000;
            int day = (int)this.world.func_72820_D() / 24000;
            this.isDay = time < 12200 || time > 23850;
            this.fullmoon = day % 8 == 0 && day > 2;
        } else {
            this.fullmoon = true;
            this.isDay = false;
        }
        if (this.index >= this.attackers.size()) {
            if (this.ticks < 20) {
                return;
            }
            this.ticks = 0;
            this.index = 0;
            this.collectEntities();
            this.digg.update();
            return;
        }
        int top = Math.min(this.index + 2, this.attackers.size());
        while (this.index < top) {
            EntityLivingBase target;
            int light;
            EntityCreature mob = this.attackers.get(this.index);
            if (this.isDay && Config.KILL_MOBS_DAYTIME && !mob.func_145818_k_() && !(mob instanceof EntityPigZombie) && (light = mob.func_130014_f_().func_175642_b(EnumSkyBlock.SKY, mob.func_180425_c())) > 11) {
                mob.func_70015_d(8);
                mob.func_70097_a(DamageSource.field_76372_a, 2.0f);
            }
            if ((target = this.findTargetFor(mob, 64)) == null && (target = mob.func_70638_az()) instanceof IMob) {
                target = null;
                mob.func_70624_b(null);
            }
            if (target != null) {
                mob.func_70624_b(target);
                Vec3i point = Maths.findPointTowards(mob, target, 15);
                boolean canDigg = true;
                canDigg = this.isOverworld ? (mob.field_70163_u > 40.0 ? Config.SWARM_OVERWORLD.isSwawrm(this.fullmoon) : Config.SWARM_UNDERGROUND.isSwawrm(this.fullmoon)) : (this.isNether ? Config.SWARM_NETHER : Config.SWARM_DIMENSIONS);
                if (canDigg && (mob instanceof EntityZombie || mob instanceof EntitySkeleton)) {
                    this.digg.process(mob, target);
                }
                mob.func_70661_as().func_75492_a((double)point.func_177958_n() + 0.5, (double)point.func_177956_o() + 0.5, (double)point.func_177952_p() + 0.5, 1.0);
                if (mob.func_130014_f_().func_180495_p(mob.func_180425_c()).func_185904_a().func_76224_d()) {
                    Vec3D vec = new Vec3D((Entity)target).sub((Entity)mob).normalize().scale(0.4);
                    mob.field_70159_w = vec.x;
                    mob.field_70181_x = vec.y;
                    mob.field_70179_y = vec.z;
                }
            }
            ++this.index;
        }
    }

    public EntityLivingBase findTargetFor(EntityCreature attacker, int radius) {
        AxisAlignedBB aabb = new AxisAlignedBB(attacker.field_70165_t - (double)radius, attacker.field_70163_u - (double)radius - (double)radius, attacker.field_70161_v - (double)radius, attacker.field_70165_t + (double)radius, attacker.field_70163_u + (double)radius + (double)radius, attacker.field_70161_v + (double)radius);
        EntityLivingBase nearest = null;
        double ndistSq = Double.POSITIVE_INFINITY;
        for (EntityLivingBase ent : this.targets) {
            if (!ent.func_70089_S() || !Maths.contains(aabb, (Entity)ent)) continue;
            double dx = attacker.field_70165_t - ent.field_70165_t;
            double dy = attacker.field_70163_u - ent.field_70163_u;
            double dz = attacker.field_70161_v - ent.field_70161_v;
            double distSq = dx * dx + dz * dz;
            double distHeight = Math.abs(dy);
            if (distSq > (double)(radius * radius) || (ent instanceof EntityAnimal || ent instanceof EntityVillager) && attacker instanceof EntityCreeper || (ent instanceof EntityGolem || ent instanceof EntityAnimal) && distSq > 400.0) continue;
            if (!(ent instanceof EntityPlayer)) {
                distSq += distSq;
            }
            if (!(distSq < ndistSq) || this.isOverworld && (ent.field_70163_u < 40.0 ? attacker.field_70163_u > 40.0 : attacker.field_70163_u < 40.0)) continue;
            nearest = ent;
            ndistSq = distSq;
        }
        return nearest;
    }

    private void collectEntities() {
        this.attackers.clear();
        this.targets.clear();
        for (Entity ent : this.world.field_72996_f) {
            if (ent instanceof EntityEnderman) continue;
            if (ent instanceof EntityCreature && (ent instanceof EntityMob || ent instanceof IMob)) {
                if (this.isSurface(ent) && !Config.SWARM_OVERWORLD.isSwawrm(this.fullmoon) && (ent instanceof EntityEnderman || MonsterSwarmMod.isSurfaceExcluded(ent))) continue;
                this.attackers.add((EntityCreature)ent);
                continue;
            }
            if (!(ent instanceof EntityPlayer) || ((EntityPlayer)ent).field_71075_bZ.field_75098_d || ((EntityPlayer)ent).func_175149_v()) continue;
            this.targets.add((EntityLivingBase)ent);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.run();
    }
}

