/*
 * Decompiled with CFR 0.152.
 */
package eu.keray.swarm;

import java.lang.reflect.Array;

public class ObjPool<T> {
    Class<T> clazz;
    T[] stack;
    private int size;

    public ObjPool(Class<T> clazz) {
        this.clazz = clazz;
        this.stack = (Object[])Array.newInstance(clazz, 128);
    }

    public T take() {
        try {
            if (this.size <= 0) {
                return this.clazz.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.stack[--this.size];
    }

    private void ensureSize(int size) {
        if (this.stack.length < size) {
            int newsize = Math.max((int)((float)this.stack.length * 1.4f), this.stack.length + 10);
            Object[] newstack = (Object[])Array.newInstance(this.clazz, newsize);
            System.arraycopy(this.clazz, 0, newstack, 0, this.size);
            this.stack = newstack;
        }
    }

    public void give(T obj) {
        this.ensureSize(this.size + 1);
        this.stack[this.size++] = obj;
    }
}

