/*
 * Decompiled with CFR 0.152.
 */
package eu.keray.swarm;

import eu.keray.swarm.Config;
import eu.keray.swarm.EventHandling;
import eu.keray.swarm.Magic;
import eu.keray.swarm.SwarmWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="monsterswarm", name="Monster Swarm", version="2.0.1", acceptedMinecraftVersions="[1.12.2]")
public class MonsterSwarmMod {
    public static final String MODID = "monsterswarm";
    public static final String NAME = "Monster Swarm";
    public static final String VERSION = "2.0.1";
    public static Logger logger;
    @Mod.Instance(value="monsterswarm")
    public static MonsterSwarmMod INSTANCE;
    public static final List<Class> ExcludedSurfaceAttackers;
    public static final List<Class> ExcludedAttackers;
    public static final List<Class> IncludedAttackers;
    public static final List<Class> IncludedTargets;
    public static final List<Class> IncludedDiggers;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Config.preInit(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        new EventHandling();
        if (Config.MODIFY_RESISTANCE) {
            Blocks.field_150343_Z.func_149752_b(10.0f);
            Blocks.field_150336_V.func_149752_b(18.0f);
            Blocks.field_150347_e.func_149752_b(11.0f);
            Blocks.field_150417_aV.func_149752_b(16.0f);
            Blocks.field_150389_bf.func_149752_b(15.0f);
            Blocks.field_150390_bg.func_149752_b(12.0f);
            Blocks.field_150322_A.func_149752_b(15.0f);
            Blocks.field_150372_bz.func_149752_b(12.0f);
            Blocks.field_180395_cM.func_149752_b(15.0f);
            Blocks.field_180396_cN.func_149752_b(12.0f);
            Blocks.field_150355_j.func_149752_b(3.0f);
            Blocks.field_150333_U.func_149752_b(12.0f);
            Blocks.field_150353_l.func_149752_b(4.0f);
            Blocks.field_150385_bj.func_149752_b(12.0f);
            Magic.setResist("Railcraft:brick.infernal", 16.0f);
            Magic.setResist("Railcraft:brick.abyssal", 16.0f);
            Magic.setResist("Railcraft:brick.sandy", 16.0f);
            Magic.setResist("Railcraft:brick.frostbound", 16.0f);
            Magic.setResist("Railcraft:brick.quarried", 16.0f);
            Magic.setResist("Railcraft:brick.bleachedbone", 16.0f);
            Magic.setResist("Railcraft:brick.bloodstained", 16.0f);
            Magic.setResist("Railcraft:brick.nether", 16.0f);
            Magic.setResist("Railcraft:stair", 12.0f);
            Magic.setResist("Railcraft:wall.beta", 12.0f);
            Magic.setResist("Railcraft:wall.alpha", 12.0f);
            Magic.setResist("Railcraft:slab", 12.0f);
            Magic.setResist("BiomesOPlenty:mudBricks", 15.0f);
            Magic.setResist("BiomesOPlenty:mudBricksStairs", 11.0f);
            Magic.setResist("MineFactoryReloaded:brick", 16.0f);
            Magic.addClass(IncludedAttackers, "net.minecraft.entity.monster.EntityMob");
            Magic.addClass(IncludedAttackers, "net.minecraft.entity.monster.IMob");
            Magic.addClass(IncludedAttackers, "drzhark.mocreatures.entity.passive.MoCEntityBear");
            Magic.addClass(IncludedAttackers, "drzhark.mocreatures.entity.passive.MoCEntityBoar");
            Magic.addClass(IncludedAttackers, "drzhark.mocreatures.entity.passive.MoCEntityCrocodile");
            Magic.addClass(ExcludedSurfaceAttackers, "drzhark.mocreatures.entity.monster.MoCEntityGolem");
            Magic.addClass(ExcludedSurfaceAttackers, "drzhark.mocreatures.entity.monster.MoCEntityMiniGolem");
            Magic.addClass(ExcludedSurfaceAttackers, "drzhark.mocreatures.entity.monster.MoCEntityOgre");
            Magic.addClass(ExcludedAttackers, "net.minecraft.entity.monster.EntityEnderman");
            Magic.addClass(ExcludedAttackers, "crazypants.enderzoo.entity.EntityOwl");
            Magic.addClass(IncludedDiggers, "drzhark.mocreatures.entity.monster.MoCEntitySilverSkeleton");
            Magic.addClass(IncludedDiggers, "net.minecraft.entity.monster.EntityZombie");
            Magic.addClass(IncludedDiggers, "net.minecraft.entity.monster.EntitySkeleton");
            Magic.addClass(IncludedDiggers, "com.gw.dm.entity.EntityLizalfos");
            Magic.addClass(IncludedDiggers, "com.gw.dm.entity.EntityRakshasa");
            Magic.addClass(IncludedDiggers, "com.gw.dm.entity.EntityCaveFisher");
            Magic.addClass(IncludedTargets, "net.minecraft.entity.player.EntityPlayer");
            Magic.addClass(IncludedTargets, "net.minecraft.entity.monster.EntityGolem");
            Magic.addClass(IncludedTargets, "net.minecraft.entity.passive.EntityVillager");
            Magic.addClass(IncludedTargets, "net.shadowmage.ancientwarfare.npc.entity.NpcBase");
        }
    }

    public static boolean isSurfaceExcluded(Entity ent) {
        for (Class c : ExcludedSurfaceAttackers) {
            if (!c.isInstance(ent)) continue;
            return true;
        }
        return false;
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartedEvent event) {
        for (WorldServer ws : DimensionManager.getWorlds()) {
            if (ws == null) continue;
            SwarmWorld swarmWorld = new SwarmWorld(ws);
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
    }

    static {
        ExcludedSurfaceAttackers = new ArrayList<Class>();
        ExcludedAttackers = new ArrayList<Class>();
        IncludedAttackers = new ArrayList<Class>();
        IncludedTargets = new ArrayList<Class>();
        IncludedDiggers = new ArrayList<Class>();
    }
}

