/*
 * Decompiled with CFR 0.152.
 */
package eu.keray.swarm;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;

public class Maths {
    public static double fastSqrt(double a) {
        return Double.longBitsToDouble((Double.doubleToLongBits(a) - 0x10000000000000L >> 1) + 0x2000000000000000L);
    }

    public static double fastSqrtNewton(double a) {
        double sqrt = Maths.fastSqrt(a);
        sqrt = (sqrt + a / sqrt) / 2.0;
        return (sqrt + a / sqrt) / 2.0;
    }

    public static Vec3i findPointTowards(EntityCreature attacker, EntityLivingBase target, int dist) {
        double dx = target.field_70165_t - attacker.field_70165_t;
        double dy = target.field_70163_u - attacker.field_70163_u;
        double dz = target.field_70161_v - attacker.field_70161_v;
        double len = Maths.fastSqrtNewton(dx * dx + dy * dy + dz * dz);
        if (len < (double)dist) {
            return new Vec3i(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        }
        dx = dx / len * (double)dist;
        dy = dy / len * (double)dist;
        dz = dz / len * (double)dist;
        return new Vec3i(attacker.field_70165_t + dx, attacker.field_70163_u + dy, attacker.field_70161_v + dz);
    }

    public static final boolean contains(AxisAlignedBB aabb, Entity ent) {
        return ent.field_70165_t >= aabb.field_72340_a && ent.field_70165_t <= aabb.field_72336_d && ent.field_70163_u >= aabb.field_72338_b && ent.field_70163_u <= aabb.field_72337_e && ent.field_70161_v >= aabb.field_72339_c && ent.field_70161_v <= aabb.field_72334_f;
    }
}

