/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import java.util.AbstractList;
import java.util.List;

public class Ranges {
    public static List<Integer> rangeList(int start, int end, int stride) {
        return new RangeList(start, end, end < start ? -stride : stride);
    }

    public static int[] range(int start, int end, int stride) {
        if (end < start) {
            int[] range = new int[(start - end) / stride];
            for (int i = 0; i < range.length; ++i) {
                range[i] = i * -stride + start;
            }
            return range;
        }
        int[] range = new int[(end - start) / stride];
        for (int i = 0; i < range.length; ++i) {
            range[i] = i * stride + start;
        }
        return range;
    }

    public static List<Integer> rangeList(int start, int end) {
        return Ranges.rangeList(start, end, 1);
    }

    public static int[] range(int start, int end) {
        return Ranges.range(start, end, 1);
    }

    public static List<Integer> toIterable(int end) {
        return Ranges.rangeList(0, end, 1);
    }

    public static int[] to(int end) {
        return Ranges.range(0, end, 1);
    }

    protected static class RangeList
    extends AbstractList<Integer> {
        protected int start;
        protected int end;
        protected int stride;

        public RangeList(int start, int end, int stride) {
            this.start = start;
            this.end = end;
            this.stride = stride;
        }

        @Override
        public Integer get(int index) {
            if (index >= this.size() || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.start + this.stride * index;
        }

        @Override
        public int size() {
            if (this.stride > 0) {
                return (this.end - this.start + (this.stride - 1)) / this.stride;
            }
            return (this.end - this.start + (this.stride + 1)) / this.stride;
        }
    }
}

