/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.worldgen;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class LogFruitTreeGen
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final IBlockState metaWood;
    private final IBlockState metaLeaves;
    private final IBlockState fruitType;

    public LogFruitTreeGen(int minTreeHeight, IBlockState metaWood, IBlockState metaLeaves, IBlockState fruitType) {
        super(true);
        this.minTreeHeight = minTreeHeight;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
        this.fruitType = fruitType;
    }

    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World worldIn, Random rand, BlockPos blockPos) {
        int treeHeight = rand.nextInt(3) + this.minTreeHeight;
        int treeTopPos = blockPos.func_177956_o() + treeHeight;
        boolean canGenerate = true;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        if (blockPos.func_177956_o() >= 1 && treeTopPos <= 255) {
            for (int iPosY = blockPos.func_177956_o(); iPosY <= treeTopPos + 1; ++iPosY) {
                int k = 1;
                if (iPosY == blockPos.func_177956_o()) {
                    k = 0;
                }
                if (iPosY >= treeTopPos - 1) {
                    k = 2;
                }
                int xEnd = blockPos.func_177958_n() + k;
                for (int xStart = blockPos.func_177958_n() - k; xStart <= xEnd && canGenerate; ++xStart) {
                    int zEnd = blockPos.func_177952_p() + k;
                    for (int zStart = blockPos.func_177952_p() - k; zStart <= zEnd && canGenerate; ++zStart) {
                        if (iPosY >= 0 && iPosY < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutableBlockPos.func_181079_c(xStart, iPosY, zStart))) continue;
                            canGenerate = false;
                            continue;
                        }
                        canGenerate = false;
                    }
                }
            }
            if (!canGenerate) {
                return false;
            }
            BlockPos blockPosDown = blockPos.func_177977_b();
            IBlockState blockStateDown = worldIn.func_180495_p(blockPosDown);
            Block blockDown = blockStateDown.func_177230_c();
            boolean isSoil = blockDown.canSustainPlant(blockStateDown, (IBlockAccess)worldIn, blockPosDown, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && treeTopPos < 255) {
                blockDown.onPlantGrow(blockStateDown, worldIn, blockPosDown, blockPos);
                for (int iPosY = blockPos.func_177956_o() - 3 + treeHeight; iPosY <= treeTopPos; ++iPosY) {
                    int distanceToTop = iPosY - treeTopPos;
                    int margin = 1 - distanceToTop / 2;
                    int xEnd = blockPos.func_177958_n() + margin;
                    for (int xStart = blockPos.func_177958_n() - margin; xStart <= xEnd; ++xStart) {
                        int currentMarginX = Math.abs(xStart - blockPos.func_177958_n());
                        int zEnd = blockPos.func_177952_p() + margin;
                        for (int zStart = blockPos.func_177952_p() - margin; zStart <= zEnd; ++zStart) {
                            BlockPos blockpos;
                            IBlockState leavesBlockState;
                            Block leavesBlock;
                            int currentMarginZ = Math.abs(zStart - blockPos.func_177952_p());
                            if (currentMarginX == margin && currentMarginZ == margin && (rand.nextInt(2) == 0 || distanceToTop == 0) || !(leavesBlock = (leavesBlockState = worldIn.func_180495_p(blockpos = new BlockPos(xStart, iPosY, zStart))).func_177230_c()).isAir(leavesBlockState, (IBlockAccess)worldIn, blockpos) && !leavesBlock.isLeaves(leavesBlockState, (IBlockAccess)worldIn, blockpos) && leavesBlock.func_149688_o(leavesBlockState) != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, blockpos, this.metaLeaves);
                        }
                    }
                }
                for (int i = 0; i < treeHeight; ++i) {
                    BlockPos upN = blockPos.func_177981_b(i);
                    IBlockState blockStateUp = worldIn.func_180495_p(upN);
                    Block blockUp = blockStateUp.func_177230_c();
                    if (blockUp.isAir(blockStateUp, (IBlockAccess)worldIn, upN)) {
                        this.func_175903_a(worldIn, blockPos.func_177981_b(i), this.fruitType);
                    }
                    if (!blockUp.isLeaves(blockStateUp, (IBlockAccess)worldIn, upN)) continue;
                    this.func_175903_a(worldIn, blockPos.func_177981_b(i), this.metaWood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

