/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import squeek.spiceoflife.helpers.InventoryHelper;
import squeek.spiceoflife.interfaces.ISaveable;
import squeek.spiceoflife.inventory.INBTInventoryHaver;

public class NBTInventory
implements ISaveable,
IInventory,
ICapabilityProvider {
    protected NonNullList<ItemStack> inventoryItems;
    protected INBTInventoryHaver inventoryHaver = null;

    public NBTInventory() {
        this(0);
    }

    public NBTInventory(int inventorySize) {
        this((NonNullList<ItemStack>)NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a));
    }

    public NBTInventory(ItemStack[] inventoryItems) {
        this(InventoryHelper.itemStackArrayToList(inventoryItems));
    }

    public NBTInventory(NonNullList<ItemStack> inventoryItems) {
        this.inventoryItems = inventoryItems;
    }

    public NBTInventory(INBTInventoryHaver inventoryHaver) {
        this(inventoryHaver.getSizeInventory());
        this.inventoryHaver = inventoryHaver;
    }

    public IItemHandlerModifiable getItemHandler() {
        return new InvWrapper((IInventory)this);
    }

    protected void onSlotFilled(int slotNum) {
    }

    protected void onSlotEmptied(int slotNum) {
    }

    public void onInventoryChanged() {
    }

    public boolean isInventoryEmpty() {
        for (ItemStack itemStack : this.inventoryItems) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean isInventoryEmpty(NBTTagCompound data) {
        NBTTagList items = data.func_150295_c("Items", 10);
        return items.func_74745_c() == 0;
    }

    public boolean isInventoryFull() {
        for (ItemStack itemStack : this.inventoryItems) {
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() >= Math.min(this.func_70297_j_(), itemStack.func_77976_d())) continue;
            return false;
        }
        return true;
    }

    public boolean isValidSlotNum(int slotNum) {
        return slotNum < this.func_70302_i_() && slotNum >= 0;
    }

    public int func_70302_i_() {
        return this.inventoryItems.size();
    }

    public boolean func_191420_l() {
        return this.isInventoryEmpty();
    }

    @Nonnull
    public ItemStack func_70301_a(int slotNum) {
        if (this.isValidSlotNum(slotNum)) {
            return (ItemStack)this.inventoryItems.get(slotNum);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slotNum, int count) {
        ItemStack itemStack = this.func_70301_a(slotNum);
        if (!itemStack.func_190926_b()) {
            if (itemStack.func_190916_E() <= count) {
                this.func_70299_a(slotNum, ItemStack.field_190927_a);
            } else {
                itemStack = itemStack.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return itemStack;
    }

    @Nonnull
    public ItemStack func_70304_b(int slotNum) {
        ItemStack item = this.func_70301_a(slotNum);
        this.func_70299_a(slotNum, ItemStack.field_190927_a);
        return item;
    }

    public void func_70299_a(int slotNum, @Nonnull ItemStack itemStack) {
        if (!this.isValidSlotNum(slotNum)) {
            return;
        }
        boolean wasEmpty = this.func_70301_a(slotNum).func_190926_b();
        this.inventoryItems.set(slotNum, (Object)itemStack);
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        if (wasEmpty && !itemStack.func_190926_b()) {
            this.onSlotFilled(slotNum);
        } else if (!wasEmpty && itemStack.func_190926_b()) {
            this.onSlotEmptied(slotNum);
        }
        this.func_70296_d();
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.inventoryHaver != null) {
            return this.inventoryHaver.getInvName(this);
        }
        return "unnamed";
    }

    public boolean func_145818_k_() {
        return this.inventoryHaver != null && this.inventoryHaver.hasCustomName(this);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        if (this.inventoryHaver != null) {
            return this.inventoryHaver.getInventoryStackLimit(this);
        }
        return 64;
    }

    public void func_70296_d() {
        this.onInventoryChanged();
        if (this.inventoryHaver != null) {
            this.inventoryHaver.onInventoryChanged(this);
        }
    }

    public boolean func_94041_b(int slotNum, @Nonnull ItemStack itemStack) {
        return this.inventoryHaver == null || this.inventoryHaver.isItemValidForSlot(this, slotNum, itemStack);
    }

    public boolean func_70300_a(@Nonnull EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    @Override
    public void writeToNBTData(NBTTagCompound data) {
        NBTTagList items = new NBTTagList();
        for (int slotNum = 0; slotNum < this.func_70302_i_(); ++slotNum) {
            ItemStack stack = this.func_70301_a(slotNum);
            if (stack.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)slotNum);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        data.func_74782_a("Items", (NBTBase)items);
    }

    @Override
    public void readFromNBTData(NBTTagCompound data) {
        NBTTagList items = data.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(item));
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler());
        }
        return null;
    }
}

