/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileHelper {
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        FileHelper.copyFile(sourceFile, destFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile, boolean overwrite) throws IOException {
        try (FileInputStream sourceInput = null;){
            sourceInput = new FileInputStream(sourceFile);
            FileHelper.copyFile(sourceInput, destFile, overwrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(InputStream sourceInput, File destFile, boolean overwrite) throws IOException {
        if (destFile.exists()) {
            if (!overwrite) return;
            assert (destFile.delete());
        } else assert (destFile.createNewFile());
        try (FileOutputStream destOutput = null;){
            int readBytes;
            destOutput = new FileOutputStream(destFile);
            byte[] buffer = new byte[4096];
            while ((readBytes = sourceInput.read(buffer)) > 0) {
                destOutput.write(buffer, 0, readBytes);
            }
            return;
        }
    }
}

