/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.client.gui;

import com.google.common.collect.Ordering;
import de.guntram.mcmod.durabilityviewer.DurabilityViewer;
import de.guntram.mcmod.durabilityviewer.handler.ConfigurationHandler;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemCountIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemDamageIndicator;
import de.guntram.mcmod.durabilityviewer.itemindicator.ItemIndicator;
import de.guntram.mcmod.durabilityviewer.sound.ItemBreakingWarner;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.Display;

public class GuiItemDurability
extends Gui {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private static boolean visible;
    private final FontRenderer fontRenderer;
    private final RenderItem itemRenderer;
    private static final int iconWidth = 16;
    private static final int iconHeight = 16;
    private static final int spacing = 2;
    private ItemBreakingWarner mainHandWarner;
    private ItemBreakingWarner offHandWarner;
    private ItemBreakingWarner helmetWarner;
    private ItemBreakingWarner chestWarner;
    private ItemBreakingWarner pantsWarner;
    private ItemBreakingWarner bootsWarner;

    public static void toggleVisibility() {
        visible = !visible;
    }

    public GuiItemDurability() {
        this.fontRenderer = this.minecraft.field_71466_p;
        this.itemRenderer = this.minecraft.func_175599_af();
        visible = true;
        this.mainHandWarner = new ItemBreakingWarner();
        this.offHandWarner = new ItemBreakingWarner();
        this.helmetWarner = new ItemBreakingWarner();
        this.chestWarner = new ItemBreakingWarner();
        this.pantsWarner = new ItemBreakingWarner();
        this.bootsWarner = new ItemBreakingWarner();
    }

    private int getInventoryArrowCount() {
        int arrows = 0;
        for (ItemStack stack : this.minecraft.field_71439_g.field_71071_by.field_70462_a) {
            if (!this.isArrow(stack)) continue;
            arrows += stack.func_190916_E();
        }
        return arrows;
    }

    private ItemStack getFirstArrowStack() {
        if (this.isArrow(this.minecraft.field_71439_g.func_184586_b(EnumHand.OFF_HAND))) {
            return this.minecraft.field_71439_g.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(this.minecraft.field_71439_g.func_184586_b(EnumHand.MAIN_HAND))) {
            return this.minecraft.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        }
        int size = this.minecraft.field_71439_g.field_71071_by.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemstack = this.minecraft.field_71439_g.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrow(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemArrow;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRender(RenderGameOverlayEvent.Post event) {
        int ypos;
        int xposTools;
        int xposArmor;
        String newTitle = DurabilityViewer.getAndResetChangedWindowTitle();
        if (newTitle != null) {
            Display.setTitle((String)newTitle);
        }
        if (!visible || event.isCanceled() || this.minecraft.field_71439_g.field_71075_bZ.field_75098_d || this.minecraft.field_71474_y.field_74325_U || event.getType() != RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            return;
        }
        EntityPlayerSP effectivePlayer = this.minecraft.field_71439_g;
        boolean needToWarn = false;
        ItemDamageIndicator mainHand = new ItemDamageIndicator(effectivePlayer.func_184582_a(EntityEquipmentSlot.MAINHAND));
        ItemDamageIndicator offHand = new ItemDamageIndicator(effectivePlayer.func_184582_a(EntityEquipmentSlot.OFFHAND));
        ItemDamageIndicator boots = new ItemDamageIndicator(effectivePlayer.func_184582_a(EntityEquipmentSlot.FEET));
        ItemDamageIndicator leggings = new ItemDamageIndicator(effectivePlayer.func_184582_a(EntityEquipmentSlot.LEGS));
        ItemDamageIndicator chestplate = new ItemDamageIndicator(effectivePlayer.func_184582_a(EntityEquipmentSlot.CHEST));
        ItemDamageIndicator helmet = new ItemDamageIndicator(effectivePlayer.func_184582_a(EntityEquipmentSlot.HEAD));
        ItemCountIndicator arrows = null;
        InventorySlotsIndicator invSlots = ConfigurationHandler.getShowChestIcon() ? new InventorySlotsIndicator(this.minecraft.field_71439_g.field_71071_by) : null;
        needToWarn |= this.mainHandWarner.checkBreaks(effectivePlayer.func_184582_a(EntityEquipmentSlot.MAINHAND));
        needToWarn |= this.offHandWarner.checkBreaks(effectivePlayer.func_184582_a(EntityEquipmentSlot.OFFHAND));
        needToWarn |= this.bootsWarner.checkBreaks(effectivePlayer.func_184582_a(EntityEquipmentSlot.FEET));
        needToWarn |= this.pantsWarner.checkBreaks(effectivePlayer.func_184582_a(EntityEquipmentSlot.LEGS));
        needToWarn |= this.chestWarner.checkBreaks(effectivePlayer.func_184582_a(EntityEquipmentSlot.CHEST));
        if (needToWarn |= this.helmetWarner.checkBreaks(effectivePlayer.func_184582_a(EntityEquipmentSlot.HEAD))) {
            ItemBreakingWarner.playWarningSound();
        }
        if (mainHand.getItemStack().func_77973_b() instanceof ItemBow || offHand.getItemStack().func_77973_b() instanceof ItemBow) {
            arrows = new ItemCountIndicator(this.getFirstArrowStack(), this.getInventoryArrowCount());
        }
        ScaledResolution screensize = new ScaledResolution(this.minecraft);
        RenderSize armorSize = this.renderItems(0, 0, false, RenderPos.left, 0, boots, leggings, chestplate, helmet);
        RenderSize toolsSize = this.renderItems(0, 0, false, RenderPos.right, 0, invSlots, mainHand, offHand, arrows);
        int totalHeight = toolsSize.height > armorSize.height ? toolsSize.height : armorSize.height;
        int totalWidth = toolsSize.width > armorSize.width ? toolsSize.width : armorSize.width;
        switch (ConfigurationHandler.getCorner()) {
            case TOP_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = 5;
                break;
            }
            case TOP_RIGHT: {
                xposArmor = screensize.func_78326_a() - 5 - armorSize.width;
                xposTools = screensize.func_78326_a() - 5 - armorSize.width - toolsSize.width;
                ypos = 60;
                break;
            }
            case BOTTOM_LEFT: {
                xposArmor = 5;
                xposTools = 5 + armorSize.width;
                ypos = screensize.func_78328_b() - 5 - totalHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                xposArmor = screensize.func_78326_a() - 5 - armorSize.width;
                xposTools = screensize.func_78326_a() - 5 - armorSize.width - toolsSize.width;
                ypos = screensize.func_78328_b() - 5 - totalHeight;
                break;
            }
            default: {
                return;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        if (ConfigurationHandler.getArmorAroundHotbar()) {
            int leftOffset = -130;
            if (!effectivePlayer.func_184582_a(EntityEquipmentSlot.OFFHAND).func_190926_b()) {
                leftOffset -= 20;
            }
            this.renderItems(screensize.func_78326_a() / 2 + leftOffset, screensize.func_78328_b() - 32 - 2, true, RenderPos.left, armorSize.width, helmet);
            this.renderItems(screensize.func_78326_a() / 2 + leftOffset, screensize.func_78328_b() - 16 - 2, true, RenderPos.left, armorSize.width, chestplate);
            this.renderItems(screensize.func_78326_a() / 2 + 100, screensize.func_78328_b() - 32 - 2, true, RenderPos.right, armorSize.width, leggings);
            this.renderItems(screensize.func_78326_a() / 2 + 100, screensize.func_78328_b() - 16 - 2, true, RenderPos.right, armorSize.width, boots);
            xposTools = ConfigurationHandler.getCorner().isRight() ? (xposTools += armorSize.width) : (xposTools -= armorSize.width);
        } else {
            this.renderItems(xposArmor, ypos, true, ConfigurationHandler.getCorner().isLeft() ? RenderPos.left : RenderPos.right, armorSize.width, helmet, chestplate, leggings, boots);
        }
        this.renderItems(xposTools, ypos, true, ConfigurationHandler.getCorner().isRight() ? RenderPos.right : RenderPos.left, toolsSize.width, invSlots, mainHand, offHand, arrows);
        RenderHelper.func_74518_a();
        if (ConfigurationHandler.showEffectDuration()) {
            Collection collection = this.minecraft.field_71439_g.func_70651_bq();
            int posGood = 0;
            int posBad = 0;
            for (PotionEffect potioneffect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
                if (!potioneffect.func_188418_e()) continue;
                Potion potion = potioneffect.func_188419_a();
                int xpos = screensize.func_78326_a();
                if (potion.func_188408_i()) {
                    xpos -= (posGood += 25);
                    ypos = 15;
                } else {
                    xpos -= (posBad += 25);
                    ypos = 41;
                }
                int duration = potioneffect.func_76459_b();
                String show = duration > 1200 ? duration / 1200 + "m" : duration / 20 + "s";
                this.fontRenderer.func_78276_b(show, xpos + 2, ypos, ItemIndicator.color_yellow);
            }
        }
    }

    private RenderSize renderItems(int xpos, int ypos, boolean reallyDraw, RenderPos numberPos, int maxWidth, ItemIndicator ... items) {
        RenderSize result = new RenderSize(0, 0);
        for (ItemIndicator item : items) {
            if (item == null || item.isEmpty() || !item.isItemStackDamageable()) continue;
            String displayString = item.getDisplayValue();
            int width = this.fontRenderer.func_78256_a(displayString);
            if (width > result.width) {
                result.width = width;
            }
            if (reallyDraw) {
                int color = item.getDisplayColor();
                this.itemRenderer.func_180450_b(item.getItemStack(), numberPos == RenderPos.left ? xpos + maxWidth - 16 - 2 : xpos, ypos + result.height);
                this.fontRenderer.func_78276_b(displayString, numberPos != RenderPos.right ? xpos : xpos + 16 + 2, ypos + result.height + this.fontRenderer.field_78288_b / 2 + (numberPos == RenderPos.over ? 10 : 0), color);
            }
            result.height += 16;
        }
        if (result.width != 0) {
            result.width += 20;
        }
        return result;
    }

    private static enum RenderPos {
        left,
        over,
        right;

    }

    private class RenderSize {
        int width;
        int height;

        RenderSize(int w, int h) {
            this.width = w;
            this.height = h;
        }
    }
}

