/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.loot;

import fathertoast.specialmobs.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.loot.LootPoolBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;

public class LootTableBuilder {
    private final List<LootPool> pools = new ArrayList<LootPool>();

    public LootTable toLootTable() {
        return new LootTable(this.pools.toArray(new LootPool[0]));
    }

    public LootTableBuilder addPool(LootPool pool) {
        this.pools.add(pool);
        return this;
    }

    public LootTableBuilder addLootTable(String id, String name, ResourceLocation lootTable) {
        return this.addPool(new LootPoolBuilder(id).addEntryTable(name, lootTable).toLootPool());
    }

    public LootTableBuilder addGuaranteedDrop(String id, String name, Block block, int count) {
        return this.addGuaranteedDrop(id, name, Item.func_150898_a((Block)block), count);
    }

    public LootTableBuilder addGuaranteedDrop(String id, String name, Item item, int count) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(count).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addCommonDrop(String id, String name, Block block) {
        return this.addCommonDrop(id, name, Item.func_150898_a((Block)block));
    }

    public LootTableBuilder addCommonDrop(String id, String name, Item item) {
        return this.addCommonDrop(id, name, item, 2);
    }

    public LootTableBuilder addCommonDrop(String id, String name, ItemStack item) {
        return this.addCommonDrop(id, name, item, 2);
    }

    public LootTableBuilder addCommonDrop(String id, String name, Block block, int max) {
        return this.addCommonDrop(id, name, Item.func_150898_a((Block)block), max);
    }

    public LootTableBuilder addCommonDrop(String id, String name, Item item, int max) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(0, max).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addCommonDrop(String id, String name, ItemStack item, int max) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(0, max).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addSemicommonDrop(String id, String name, Block block) {
        return this.addSemicommonDrop(id, name, Item.func_150898_a((Block)block));
    }

    public LootTableBuilder addSemicommonDrop(String id, String name, Item item) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootPoolBuilder.KILLED_BY_PLAYER_CONDITION).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(-1, 1).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addSemicommonDrop(String id, String name, ItemStack item) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootPoolBuilder.KILLED_BY_PLAYER_CONDITION).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(-1, 1).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addClusterDrop(String id, String name, Block block) {
        return this.addClusterDrop(id, name, Item.func_150898_a((Block)block));
    }

    public LootTableBuilder addClusterDrop(String id, String name, Item item) {
        return this.addClusterDrop(id, name, item, 8);
    }

    public LootTableBuilder addClusterDrop(String id, String name, ItemStack item) {
        return this.addClusterDrop(id, name, item, 8);
    }

    public LootTableBuilder addClusterDrop(String id, String name, Block block, int max) {
        return this.addClusterDrop(id, name, Item.func_150898_a((Block)block), max);
    }

    public LootTableBuilder addClusterDrop(String id, String name, Item item, int max) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(1, max).addLootingBonus(0.0f, (float)max / 4.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addClusterDrop(String id, String name, ItemStack item, int max) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(1, max).addLootingBonus(0.0f, (float)max / 4.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addUncommonDrop(String id, String name, Block ... blocks) {
        return this.addUncommonDrop(id, name, LootTableBuilder.toItemArray(blocks));
    }

    public LootTableBuilder addUncommonDrop(String id, String name, Item ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addUncommonDrop(String id, String name, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).setWeight(items[i].func_190916_E()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addRareDrop(String id, String name, Block ... blocks) {
        return this.addRareDrop(id, name, LootTableBuilder.toItemArray(blocks));
    }

    public LootTableBuilder addRareDrop(String id, String name, Item ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.RARE_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addRareDrop(String id, String name, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.RARE_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).setWeight(items[i].func_190916_E()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addEpicDrop(String id, String name, Block ... blocks) {
        return this.addEpicDrop(id, name, LootTableBuilder.toItemArray(blocks));
    }

    public LootTableBuilder addEpicDrop(String id, String name, Item ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.EPIC_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addEpicDrop(String id, String name, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.EPIC_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).setWeight(items[i].func_190916_E()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    private static Item[] toItemArray(Block[] blocks) {
        Item[] items = new Item[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            items[i] = Item.func_150898_a((Block)blocks[i]);
        }
        return items;
    }
}

