/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.slime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.slime.Entity_SpecialSlime;
import fathertoast.specialmobs.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityCaramelSlime
extends Entity_SpecialSlime {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityCaramelSlime.GET_TEXTURE_PATH("caramel"))};
    public static ResourceLocation LOOT_TABLE;
    private int grabTime;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(10318655);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityCaramelSlime.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Sugar", Items.field_151102_aT);
        loot.addUncommonDrop("uncommon", "Slime color", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.ORANGE.func_176767_b()));
    }

    public EntityCaramelSlime(World world) {
        super(world);
    }

    @Override
    protected EntitySlime getSplitSlime() {
        return new EntityCaramelSlime(this.field_70170_p);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LOOT_TABLE : LootTableList.field_186419_a;
    }

    @Override
    protected void applyTypeAttributes() {
        this.slimeExperienceValue += 2;
    }

    @Override
    protected void adjustTypeAttributesForSize(int size) {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0 * (double)size);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        --this.grabTime;
        List riders = this.func_184188_bt();
        if (this.grabTime <= 0 && !riders.isEmpty()) {
            for (Entity rider : riders) {
                if (!(rider instanceof EntityLivingBase)) continue;
                rider.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76348_h(), 1.0f);
                this.grabTime = 20;
            }
        }
    }

    @Override
    protected void onTypeAttack(Entity target) {
        if (this.grabTime <= -20 && this.func_184188_bt().isEmpty() && target.func_184205_a((Entity)this, true)) {
            this.grabTime = 20;
        }
    }
}

