/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.creeper;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.creeper.Entity_SpecialCreeper;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityDirtCreeper
extends Entity_SpecialCreeper {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityDirtCreeper.GET_TEXTURE_PATH("dirt"))};
    public static ResourceLocation LOOT_TABLE;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(7886139);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityDirtCreeper.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Dirt", Blocks.field_150346_d);
        loot.addSemicommonDrop("semicommon", "Bread", Items.field_151025_P);
        loot.addRareDrop("rare", "Root veggie", Items.field_151172_bF, Items.field_151174_bG);
    }

    public EntityDirtCreeper(World world) {
        super(world);
        this.getSpecialData().setImmuneToBurning(true);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected void applyTypeAttributes() {
        ++this.field_70728_aV;
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_188791_g, 6.0);
    }

    @Override
    public void explodeByType(boolean powered, boolean griefing) {
        float power = (float)this.field_82226_g * (powered ? 2.0f : 1.0f);
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, power, false);
        if (!griefing) {
            return;
        }
        IBlockState dirt = Blocks.field_150346_d.func_176223_P();
        int radius = (int)Math.floor(power);
        BlockPos center = new BlockPos((Entity)this);
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > radius * radius) continue;
                    BlockPos pos = center.func_177982_a(x, y, z);
                    if (!dirt.func_177230_c().func_176196_c(this.field_70170_p, pos)) continue;
                    this.field_70170_p.func_180501_a(pos, dirt, 2);
                }
            }
        }
    }
}

