/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.config;

import fathertoast.specialmobs.ObfuscationHelper;
import fathertoast.specialmobs.bestiary.EnumMobFamily;
import fathertoast.specialmobs.config.EntityListConfig;
import fathertoast.specialmobs.config.EntryEntity;
import fathertoast.specialmobs.config.EnvironmentListConfig;
import fathertoast.specialmobs.config.TargetBlock;
import fathertoast.specialmobs.config.TargetEnvironment;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

public class Config {
    public final GENERAL GENERAL = new GENERAL();
    public final CREEPERS CREEPERS = new CREEPERS();
    public final ZOMBIES ZOMBIES = new ZOMBIES();
    public final ZOMBIE_PIGMEN ZOMBIE_PIGMEN = new ZOMBIE_PIGMEN();
    public final SKELETONS SKELETONS = new SKELETONS();
    public final WITHER_SKELETONS WITHER_SKELETONS = new WITHER_SKELETONS();
    public final SLIMES SLIMES = new SLIMES();
    public final MAGMA_CUBES MAGMA_CUBES = new MAGMA_CUBES();
    public final SPIDERS SPIDERS = new SPIDERS();
    public final CAVE_SPIDERS CAVE_SPIDERS = new CAVE_SPIDERS();
    public final SILVERFISH SILVERFISH = new SILVERFISH();
    public final ENDERMEN ENDERMEN = new ENDERMEN();
    public final WITCHES WITCHES = new WITCHES();
    public final GHASTS GHASTS = new GHASTS();
    public final BLAZES BLAZES = new BLAZES();
    static Logger log;
    private static Configuration configLoading;
    private static Config INSTANCE;

    public static Config get() {
        return INSTANCE;
    }

    public static void load(Logger logger, String fileName, File configDir) {
        log = logger;
        log.info("Loading configs...");
        long startTime = System.nanoTime();
        configLoading = new Configuration(new File(configDir, fileName + ".cfg"));
        configLoading.load();
        INSTANCE = new Config();
        configLoading.save();
        configLoading = null;
        long estimatedTime = System.nanoTime() - startTime;
        log.info("Loaded configs in {} ms", (Object)((double)estimatedTime / 1000000.0));
    }

    private Config() {
    }

    private static abstract class PropertyCategory {
        static final double[] R_DBL_ALL = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_POS = new double[]{0.0, Double.POSITIVE_INFINITY};
        static final double[] R_DBL_ONE = new double[]{0.0, 1.0};
        static final float[] R_FLT_ALL = new float[]{Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_POS = new float[]{0.0f, Float.POSITIVE_INFINITY};
        static final float[] R_FLT_ONE = new float[]{0.0f, 1.0f};
        static final int[] R_INT_ALL = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        static final int[] R_INT_TOKEN_NEG = new int[]{-1, Integer.MAX_VALUE};
        static final int[] R_INT_POS0 = new int[]{0, Integer.MAX_VALUE};
        static final int[] R_INT_POS1 = new int[]{1, Integer.MAX_VALUE};
        static final int[] R_INT_SRT_POS = new int[]{0, Short.MAX_VALUE};
        static final int[] R_INT_BYT_UNS = new int[]{0, 255};
        static final int[] R_INT_BYT_POS = new int[]{0, 127};
        final String KEY;

        PropertyCategory(String key) {
            this.KEY = key;
            configLoading.addCustomCategoryComment(this.name(), this.comment());
        }

        PropertyCategory() {
            this(null);
        }

        abstract String name();

        abstract String comment();

        double[] defaultDblRange() {
            return R_DBL_POS;
        }

        float[] defaultFltRange() {
            return R_FLT_POS;
        }

        int[] defaultIntRange() {
            return R_INT_POS0;
        }

        IBlockState prop(String key, IBlockState defaultValue, String comment) {
            String target = this.cprop(key, defaultValue, comment).getString();
            String[] pair = target.split(" ", 2);
            IBlockState block = TargetBlock.getStringAsBlock(pair[0]);
            if (pair.length > 1) {
                return block.func_177230_c().func_176203_a(Integer.parseInt(pair[1].trim()));
            }
            return block;
        }

        Property cprop(String key, IBlockState defaultValue, String comment) {
            String defaultId = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultValue.func_177230_c())).toString() + " " + defaultValue.func_177230_c().func_176201_c(defaultValue);
            comment = this.amendComment(comment, "Block", (Object)defaultId, "mod_id:block_id, mod_id:block_id meta");
            return configLoading.get(this.name(), key, defaultId, comment);
        }

        HashSet<TargetBlock> prop(String key, Block[] defaultValues, String comment) {
            TargetBlock[] wrappedDefaultValues = new TargetBlock[defaultValues.length];
            for (int i = 0; i < wrappedDefaultValues.length; ++i) {
                wrappedDefaultValues[i] = new TargetBlock(defaultValues[i]);
            }
            return this.prop(key, wrappedDefaultValues, comment);
        }

        HashSet<TargetBlock> prop(String key, TargetBlock[] defaultValues, String comment) {
            return TargetBlock.newBlockSet(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, TargetBlock[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)defaultValues[i].BLOCK)).toString();
                if (defaultValues[i].BLOCK_DATA < 0) continue;
                defaultIds[i] = (String)defaultIds[i] + " " + defaultValues[i].BLOCK_DATA;
            }
            comment = this.amendComment(comment, "Block_Array", defaultIds, "mod_id:block_id, mod_id:block_id meta, mod_id:*");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        EntityListConfig prop(String key, EntryEntity[] defaultValues, String comment) {
            return new EntityListConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, EntryEntity[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Entity_Array", defaultIds, "entity_id <extra_data>, ~entity_id <extra_data>");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        EnvironmentListConfig prop(String key, TargetEnvironment[] defaultValues, String comment) {
            return new EnvironmentListConfig(this.cprop(key, defaultValues, comment).getStringList());
        }

        Property cprop(String key, TargetEnvironment[] defaultValues, String comment) {
            Object[] defaultIds = new String[defaultValues.length];
            for (int i = 0; i < defaultIds.length; ++i) {
                defaultIds[i] = defaultValues[i].toString();
            }
            comment = this.amendComment(comment, "Environment_Array", defaultIds, "biome/mod_id:biome_id=value, biome/mod_id:prefix*=value, dimension/dimension_id=value");
            return configLoading.get(this.name(), key, (String[])defaultIds, comment);
        }

        boolean prop(String key, boolean defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getBoolean();
        }

        Property cprop(String key, boolean defaultValue, String comment) {
            comment = this.amendComment(comment, "Boolean", (Object)defaultValue, new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValue, comment);
        }

        boolean[] prop(String key, boolean[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getBooleanList();
        }

        Property cprop(String key, boolean[] defaultValues, String comment) {
            comment = this.amendComment(comment, "Boolean_Array", (Object[])ArrayUtils.toObject((boolean[])defaultValues), new Object[]{true, false});
            return configLoading.get(this.name(), key, defaultValues, comment);
        }

        int prop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getInt();
        }

        int prop(String key, int defaultValue, String comment, int ... range) {
            return this.cprop(key, defaultValue, comment, range).getInt();
        }

        Property cprop(String key, int defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultIntRange());
        }

        Property cprop(String key, int defaultValue, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        int[] prop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getIntList();
        }

        int[] prop(String key, int[] defaultValues, String comment, int ... range) {
            return this.cprop(key, defaultValues, comment, range).getIntList();
        }

        Property cprop(String key, int[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultIntRange());
        }

        Property cprop(String key, int[] defaultValues, String comment, int ... range) {
            comment = this.amendComment(comment, "Integer_Array", ArrayUtils.toObject((int[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        float prop(String key, float defaultValue, String comment) {
            return (float)this.cprop(key, defaultValue, comment).getDouble();
        }

        float prop(String key, float defaultValue, String comment, float ... range) {
            return (float)this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, float defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultFltRange());
        }

        Property cprop(String key, float defaultValue, String comment, float ... range) {
            comment = this.amendComment(comment, "Float", Float.valueOf(defaultValue), (Object)Float.valueOf(range[0]), (Object)Float.valueOf(range[1]));
            return configLoading.get(this.name(), key, this.prettyFloatToDouble(defaultValue), comment, this.prettyFloatToDouble(range[0]), this.prettyFloatToDouble(range[1]));
        }

        double prop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment).getDouble();
        }

        double prop(String key, double defaultValue, String comment, double ... range) {
            return this.cprop(key, defaultValue, comment, range).getDouble();
        }

        Property cprop(String key, double defaultValue, String comment) {
            return this.cprop(key, defaultValue, comment, this.defaultDblRange());
        }

        Property cprop(String key, double defaultValue, String comment, double ... range) {
            comment = this.amendComment(comment, "Double", defaultValue, (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValue, comment, range[0], range[1]);
        }

        double[] prop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment).getDoubleList();
        }

        double[] prop(String key, double[] defaultValues, String comment, double ... range) {
            return this.cprop(key, defaultValues, comment, range).getDoubleList();
        }

        Property cprop(String key, double[] defaultValues, String comment) {
            return this.cprop(key, defaultValues, comment, this.defaultDblRange());
        }

        Property cprop(String key, double[] defaultValues, String comment, double ... range) {
            comment = this.amendComment(comment, "Double_Array", ArrayUtils.toObject((double[])defaultValues), (Object)range[0], (Object)range[1]);
            return configLoading.get(this.name(), key, defaultValues, comment, range[0], range[1]);
        }

        String prop(String key, String defaultValue, String comment, String valueDescription) {
            return this.cprop(key, defaultValue, comment, valueDescription).getString();
        }

        String prop(String key, String defaultValue, String comment, String ... validValues) {
            return this.cprop(key, defaultValue, comment, validValues).getString();
        }

        Property cprop(String key, String defaultValue, String comment, String valueDescription) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, valueDescription);
            return configLoading.get(this.name(), key, defaultValue, comment, new String[0]);
        }

        Property cprop(String key, String defaultValue, String comment, String ... validValues) {
            comment = this.amendComment(comment, "String", (Object)defaultValue, (Object[])validValues);
            return configLoading.get(this.name(), key, defaultValue, comment, validValues);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, String description) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), description);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object min, Object max) {
            return this.amendComment(comment, type, "{ " + this.toReadable(defaultValues) + " }", min, max);
        }

        private String amendComment(String comment, String type, Object[] defaultValues, Object[] validValues) {
            return this.amendComment(comment, type, (Object)("{ " + this.toReadable(defaultValues) + " }"), validValues);
        }

        private String amendComment(String comment, String type, Object defaultValue, String description) {
            return comment + "\n   >> " + type + ":[ Value={ " + description + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object min, Object max) {
            return comment + "\n   >> " + type + ":[ Range={ " + min + ", " + max + " }, Default=" + defaultValue + " ]";
        }

        private String amendComment(String comment, String type, Object defaultValue, Object[] validValues) {
            if (validValues.length < 2) {
                throw new IllegalArgumentException("Attempted to create config with no options!");
            }
            return comment + "\n   >> " + type + ":[ Valid_Values={ " + this.toReadable(validValues) + " }, Default=" + defaultValue + " ]";
        }

        private double prettyFloatToDouble(float f) {
            return Double.parseDouble(Float.toString(f));
        }

        private String toReadable(Object[] array) {
            if (array.length <= 0) {
                return "";
            }
            StringBuilder commentBuilder = new StringBuilder();
            for (Object value : array) {
                commentBuilder.append(value).append(", ");
            }
            return commentBuilder.substring(0, commentBuilder.length() - 2);
        }
    }

    public static abstract class FamilyConfig
    extends PropertyCategory {
        final EnumMobFamily mobFamily;
        public final boolean REPLACE_VANILLA;
        private final float SPECIAL_CHANCE;
        private final EnvironmentListConfig SPECIAL_CHANCE_EXCEPTIONS;

        @Override
        String name() {
            return this.KEY.replace(' ', '_');
        }

        @Override
        String comment() {
            return "Options related to special " + this.KEY + ".";
        }

        @Override
        float[] defaultFltRange() {
            return PropertyCategory.R_FLT_ONE;
        }

        FamilyConfig(EnumMobFamily family) {
            super(family.key);
            if (family.config != null) {
                throw new IllegalArgumentException("Mob family '" + family.name + "' already has a config attached");
            }
            this.mobFamily = family;
            family.config = this;
            this.REPLACE_VANILLA = this.prop("_replace_vanilla", true, "When true, all vanilla " + family.key + " are replaced by 'vanilla-like' versions.\nThis enables all of the mod's options that apply to special variants to also apply to vanilla mobs,\nin addition to all the nbt editing capabilities that special mobs have.");
            this.SPECIAL_CHANCE = this.prop("_special_chance", 0.6f, "The chance for " + family.key + " to spawn as special variants.");
            this.SPECIAL_CHANCE_EXCEPTIONS = this.prop("_special_chance_exceptions", new TargetEnvironment.TargetDimension[]{new TargetEnvironment.TargetDimension(DimensionType.OVERWORLD, 0.25f), new TargetEnvironment.TargetDimension(DimensionType.NETHER, 0.33f), new TargetEnvironment.TargetDimension(DimensionType.THE_END, 0.33f)}, "The chance for " + family.key + " to spawn as special variants when spawning in particular locations.\nMore specific locations take priority over others (biome < biome* < dimension < global setting).");
            for (EnumMobFamily.Species variant : this.mobFamily.variants) {
                String name = variant.name.toLowerCase();
                variant.bestiaryInfo.weight = this.prop(name + "_weight", variant.bestiaryInfo.weight, "The weight for the '" + name + "' variant to be picked when " + family.key + " spawn as special variants.");
                variant.bestiaryInfo.weightExceptions = this.prop(name + "_weight_exceptions", variant.bestiaryInfo.weightExceptions.ENTRIES.toArray(new TargetEnvironment[0]), "The weight for the '" + name + "' variant to be picked in particular locations.");
            }
        }

        public float getSpecialChance(World world, BlockPos pos) {
            return this.SPECIAL_CHANCE_EXCEPTIONS.getValueForLocation(world, pos, this.SPECIAL_CHANCE);
        }

        public int getVariantWeight(World world, BlockPos pos, EnumMobFamily.Species variant) {
            return (int)variant.bestiaryInfo.weightExceptions.getValueForLocation(world, pos, variant.bestiaryInfo.weight);
        }
    }

    public class BLAZES
    extends FamilyConfig {
        BLAZES() {
            super(EnumMobFamily.BLAZE);
        }
    }

    public class GHASTS
    extends FamilyConfig {
        GHASTS() {
            super(EnumMobFamily.GHAST);
        }
    }

    public class WITCHES
    extends FamilyConfig {
        WITCHES() {
            super(EnumMobFamily.WITCH);
        }
    }

    public class ENDERMEN
    extends FamilyConfig {
        private final HashSet<TargetBlock> CARRIABLE_BLOCKS;

        ENDERMEN() {
            super(EnumMobFamily.ENDERMAN);
            this.CARRIABLE_BLOCKS = this.prop("_carriable_blocks", new Block[]{Blocks.field_150349_c, Blocks.field_150391_bh, Blocks.field_150346_d, Blocks.field_150435_aG, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150423_aK, Blocks.field_150440_ba, Blocks.field_150434_aF, Blocks.field_150335_W, Blocks.field_150424_aL}, "Set of blocks that can be moved around by endermen. Removing all entries here disables enderman griefing.\nOther mods can still add/remove blocks from this list, so be aware of which mods do.\nUnlike most config options here, this affects vanilla endermen in addition to the endermen from this mod (and probably other mods).");
            Set<Block> carriable = ObfuscationHelper.EntityEnderman_CARRIABLE_BLOCKS.get();
            if (carriable != null) {
                carriable.clear();
            }
            for (TargetBlock target : this.CARRIABLE_BLOCKS) {
                EntityEnderman.setCarriable((Block)target.BLOCK, (boolean)true);
            }
        }
    }

    public class SILVERFISH
    extends FamilyConfig {
        public final float AGGRESSIVE_CHANCE;

        SILVERFISH() {
            super(EnumMobFamily.SILVERFISH);
            this.AGGRESSIVE_CHANCE = this.prop("_aggressive_chance", 0.2f, "Chance for silverfish to spawn already calling for reinforcements.");
        }
    }

    public class CAVE_SPIDERS
    extends FamilyConfig {
        CAVE_SPIDERS() {
            super(EnumMobFamily.CAVE_SPIDER);
        }
    }

    public class SPIDERS
    extends FamilyConfig {
        SPIDERS() {
            super(EnumMobFamily.SPIDER);
        }
    }

    public class MAGMA_CUBES
    extends FamilyConfig {
        MAGMA_CUBES() {
            super(EnumMobFamily.MAGMA_CUBE);
        }
    }

    public class SLIMES
    extends FamilyConfig {
        public final boolean TINY_SLIME_DAMAGE;

        SLIMES() {
            super(EnumMobFamily.SLIME);
            this.TINY_SLIME_DAMAGE = this.prop("_tiny_slime_damage", true, "Setting this to false makes tiny slimes incapable of dealing damage, like in vanilla.\nI don't recommend disabling this, but the option is here if you want to revert the change.");
        }
    }

    public class WITHER_SKELETONS
    extends FamilyConfig {
        public final float BABY_CHANCE;
        public final float BOW_CHANCE;

        WITHER_SKELETONS() {
            super(EnumMobFamily.WITHER_SKELETON);
            this.BABY_CHANCE = this.prop("_baby_chance", 0.05f, "Chance for wither skeletons to spawn as babies.");
            this.BOW_CHANCE = this.prop("_bow_chance", 0.05f, "Chance for valid wither skeletons to spawn with bows.");
        }
    }

    public class SKELETONS
    extends FamilyConfig {
        public final float BABY_CHANCE;
        public final float BOW_CHANCE;

        SKELETONS() {
            super(EnumMobFamily.SKELETON);
            this.BABY_CHANCE = this.prop("_baby_chance", 0.05f, "Chance for skeletons to spawn as babies.");
            this.BOW_CHANCE = this.prop("_bow_chance", 0.95f, "Chance for valid skeletons to spawn with bows.");
        }
    }

    public class ZOMBIE_PIGMEN
    extends FamilyConfig {
        public final float BOW_CHANCE;
        public final float CHICKEN_JOCKEY_CHANCE;
        public final float CHICKEN_JOCKEY_FORCED_CHANCE;

        ZOMBIE_PIGMEN() {
            super(EnumMobFamily.ZOMBIE_PIGMAN);
            this.BOW_CHANCE = this.prop("_bow_chance", 0.2f, "Chance for valid zombie pigmen to spawn with bows.");
            this.CHICKEN_JOCKEY_CHANCE = this.prop("_chicken_jockey_chance", 1.0f, "Chance for baby zombie pigmen to spawn riding on a pre-existing chicken near their spawn point.\nThe vanilla chance for this is 5%, like the forced chicken jockey version.\nSee the Forge config for zombie baby chance (forge.cfg).");
            this.CHICKEN_JOCKEY_FORCED_CHANCE = this.prop("_chicken_jockey_forced_chance", 0.05f, "Chance for baby zombie pigmen to spawn with a chicken mount.\nSee the Forge config for zombie baby chance (forge.cfg).");
        }
    }

    public class ZOMBIES
    extends FamilyConfig {
        public final float BOW_CHANCE;
        public final float CHICKEN_JOCKEY_CHANCE;
        public final float CHICKEN_JOCKEY_FORCED_CHANCE;

        ZOMBIES() {
            super(EnumMobFamily.ZOMBIE);
            this.BOW_CHANCE = this.prop("_bow_chance", 0.05f, "Chance for valid zombies to spawn with bows.");
            this.CHICKEN_JOCKEY_CHANCE = this.prop("_chicken_jockey_chance", 1.0f, "Chance for baby zombies to spawn riding on a pre-existing chicken near their spawn point.\nThe vanilla chance for this is 5%, like the forced chicken jockey version.\nSee the Forge config for zombie baby chance (forge.cfg).");
            this.CHICKEN_JOCKEY_FORCED_CHANCE = this.prop("_chicken_jockey_forced_chance", 0.05f, "Chance for baby zombies to spawn with a chicken mount.\nSee the Forge config for zombie baby chance (forge.cfg).");
        }
    }

    public class CREEPERS
    extends FamilyConfig {
        public final float CHARGED_CHANCE;

        CREEPERS() {
            super(EnumMobFamily.CREEPER);
            this.CHARGED_CHANCE = this.prop("_charged_chance", 0.01f, "Chance for creepers to spawn charged during thunderstorms.");
        }
    }

    public class GENERAL
    extends PropertyCategory {
        public final boolean DISABLE_NAUSEA = this.prop("disable_nausea_effects", false, "If true, prevents any of this mod's mobs from applying nausea when they normally would.\nUse this if the screen warping from nausea hurts your face or makes you sick.");
        public final boolean FANCY_FISHING_MOBS = this.prop("fancy_fishing_mobs", true, "Overrides the default fishing rod item animation so that it is compatible with fishing mobs from this mod.\nDisable this if it causes problems with another mod for some reason. Fishing mobs will instead render a stick while casting.");
        public final float RANDOM_SCALING = this.prop("random_scaling", 0.15f, "When greater than 0, mobs will have a random render scale applied. This is a visual effect only.\nWith a value of 0.2, mob scale can vary by 20% (+/- 10% from normal size).\nThis only affects special variants and vanilla-replacement mobs.");
        public final boolean SPAWN_EGGS = this.prop("spawn_eggs", true, "If true, the mod will attempt to generate a spawn egg for each variant mob.\nDisable this if your 'misc' creative tab is too full, or if you need to for whatever reason.");
        public final boolean SPAWNING = this.prop("spawning", true, "Set this to false to disable mob spawning from this mod entirely. Do this if you want\nto handle the spawning through another mod.");

        @Override
        String name() {
            return "_general";
        }

        @Override
        String comment() {
            return "General and/or miscellaneous options.";
        }
    }
}

