/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.bestiary;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.config.Config;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public enum EnumMobFamily {
    CREEPER("Creeper", "creepers", 894731, new Class[]{EntityCreeper.class}, "Dark", "Death", "Dirt", "Doom", "Drowning", "Ender", "Fire", "Gravel", "Jumping", "Lightning", "Mini", "Splitting"),
    ZOMBIE("Zombie", "zombies", 44975, new Class[]{EntityZombie.class, EntityHusk.class}, "Brute", "Fire", "Fishing", "Giant", "Hungry", "Husk", "Plague"),
    ZOMBIE_PIGMAN("PigZombie", "zombie pigmen", 15373203, new Class[]{EntityPigZombie.class}, "Brute", "Fishing", "Giant", "Hungry", "Knight", "Plague", "Vampire"),
    SKELETON("Skeleton", "skeletons", 0xC1C1C1, new Class[]{EntitySkeleton.class, EntityStray.class}, "Brute", "Fire", "Gatling", "Giant", "Knight", "Ninja", "Poison", "Sniper", "Spitfire", "Stray"),
    WITHER_SKELETON("WitherSkeleton", "wither skeletons", 0x141414, new Class[]{EntityWitherSkeleton.class}, "Brute", "Gatling", "Giant", "Knight", "Ninja", "Sniper", "Spitfire"),
    SLIME("Slime", "slimes", 5349438, new Class[]{EntitySlime.class}, "Blackberry", "Blueberry", "Caramel", "Grape", "Lemon", "Strawberry", "Watermelon"),
    MAGMA_CUBE("LavaSlime", "magma cubes", 0x340000, new Class[]{EntityMagmaCube.class}, "Flying", "Hardened", "Sticky", "Volatile"),
    SPIDER("Spider", "spiders", 3419431, new Class[]{EntitySpider.class}, "Baby", "Desert", "Flying", "Giant", "Hungry", "Mother", "Pale", "Poison", "Web", "Witch"),
    CAVE_SPIDER("CaveSpider", "cave spiders", 803406, new Class[]{EntityCaveSpider.class}, "Baby", "Flying", "Mother", "Web", "Witch"),
    SILVERFISH("Silverfish", "silverfish", 0x6E6E6E, new Class[]{EntitySilverfish.class}, "Blinding", "Fishing", "Flying", "Poison", "Tough"),
    ENDERMAN("Enderman", "endermen", 0x161616, new Class[]{EntityEnderman.class}, "Blinding", "Icy", "Lightning", "Mini", "Mirage", "Thief"),
    WITCH("Witch", "witches", 0x340000, new Class[]{EntityWitch.class}, "Domination", "Shadows", "Undead", "Wilds", "Wind"),
    GHAST("Ghast", "ghasts", 0xF9F9F9, new Class[]{EntityGhast.class}, "Baby", "Fighter", "King", "Queen", "Unholy"),
    BLAZE("Blaze", "blazes", 16167425, new Class[]{EntityBlaze.class}, "Cinder", "Conflagration", "Ember", "Hellfire", "Inferno", "Jolt", "Wildfire");

    public static final Map<Class, EnumMobFamily> CLASS_TO_FAMILY_MAP;
    public final String name;
    public final String key;
    public final int eggBaseColor;
    public final Class[] replaceableClasses;
    public final Species vanillaReplacement;
    public final Species[] variants;
    public Config.FamilyConfig config;

    private EnumMobFamily(String familyName, String familyKey, int eggColor, Class[] replaceable, String ... variantNames) {
        this.name = familyName;
        this.key = familyKey;
        this.eggBaseColor = eggColor;
        this.replaceableClasses = replaceable;
        String classPathRoot = "fathertoast.specialmobs.entity." + this.name.toLowerCase() + ".Entity";
        this.vanillaReplacement = new Species(this, classPathRoot);
        this.variants = this.makeVariants(classPathRoot, variantNames);
    }

    private Species[] makeVariants(String classPathRoot, String[] names) {
        Species[] familyVariants = new Species[names.length];
        for (int i = 0; i < familyVariants.length; ++i) {
            familyVariants[i] = new Species(this, classPathRoot, names[i]);
        }
        return familyVariants;
    }

    public Species nextVariant(World world, BlockPos pos) {
        int totalWeight = 0;
        int[] variantWeights = new int[this.variants.length];
        for (int i = 0; i < this.variants.length; ++i) {
            int weight = this.config.getVariantWeight(world, pos, this.variants[i]);
            if (weight <= 0) continue;
            totalWeight += weight;
            variantWeights[i] = weight;
        }
        if (totalWeight > 0) {
            int weight = world.field_73012_v.nextInt(totalWeight);
            for (int i = 0; i < this.variants.length; ++i) {
                if (variantWeights[i] <= 0 || (weight -= variantWeights[i]) >= 0) continue;
                return this.variants[i];
            }
        }
        return this.vanillaReplacement;
    }

    static {
        CLASS_TO_FAMILY_MAP = new HashMap<Class, EnumMobFamily>();
    }

    public static class Species {
        public final EnumMobFamily family;
        public final String name;
        public final String unlocalizedName;
        public final Class<EntityLiving> variantClass;
        public final BestiaryInfo bestiaryInfo;
        public final Constructor<? extends EntityLiving> constructor;

        private Species(EnumMobFamily variantFamily, String classPathRoot) {
            this.family = variantFamily;
            this.name = variantFamily.name;
            this.unlocalizedName = "Special" + this.name;
            try {
                this.variantClass = Class.forName(classPathRoot + "_" + this.unlocalizedName);
                this.bestiaryInfo = (BestiaryInfo)this.variantClass.getMethod("GET_BESTIARY_INFO", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Failed to find vanilla replacement class for mob family " + this.name, ex);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException("Vanilla replacement class for " + this.unlocalizedName + " has no valid 'GET_BESTIARY_INFO( )' method", ex);
            }
            this.constructor = ReflectionHelper.findConstructor(this.variantClass, (Class[])new Class[]{World.class});
        }

        private Species(EnumMobFamily variantFamily, String classPathRoot, String variantName) {
            this.family = variantFamily;
            this.name = variantName;
            this.unlocalizedName = this.name + this.family.name;
            try {
                this.variantClass = Class.forName(classPathRoot + this.unlocalizedName);
                this.bestiaryInfo = (BestiaryInfo)this.variantClass.getMethod("GET_BESTIARY_INFO", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Failed to find special variant class for mob species " + this.unlocalizedName, ex);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                throw new RuntimeException("Special variant class for " + this.unlocalizedName + " has no valid 'GET_BESTIARY_INFO( )' method", ex);
            }
            this.constructor = ReflectionHelper.findConstructor(this.variantClass, (Class[])new Class[]{World.class});
        }
    }
}

