/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.simpledata;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.orecruncher.lib.simpledata.ISimpleData;
import org.orecruncher.lib.simpledata.ISimpleDataRegistry;

public abstract class SimpleDataRegistry
implements ISimpleDataRegistry {
    private Map<Class<? extends ISimpleData>, ISimpleData> dataMap = null;
    private boolean isDirty;

    @Nullable
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = null;
        if (this.dataMap != null) {
            nbt = new NBTTagCompound();
            if (this.dataMap != null && !this.dataMap.isEmpty()) {
                for (Map.Entry<Class<? extends ISimpleData>, ISimpleData> e : this.dataMap.entrySet()) {
                    String key = e.getKey().getName();
                    NBTTagCompound value = (NBTTagCompound)e.getValue().serializeNBT();
                    nbt.func_74782_a(key, (NBTBase)value);
                }
            }
        }
        return nbt;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        if (nbt.func_186856_d() == 0) {
            return;
        }
        for (String className : nbt.func_150296_c()) {
            try {
                Class<?> clazz = Class.forName(className);
                ISimpleData data = this.getData(clazz);
                data.deserializeNBT((NBTBase)nbt.func_74775_l(className));
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    @Override
    @Nonnull
    public ISimpleData getData(@Nonnull Class<? extends ISimpleData> clazz) {
        ISimpleData result;
        if (this.dataMap == null) {
            this.dataMap = new IdentityHashMap<Class<? extends ISimpleData>, ISimpleData>();
        }
        if ((result = this.dataMap.get(clazz)) == null) {
            try {
                result = clazz.newInstance();
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }
}

