/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.math;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.math.MathStuff;

public final class RayTrace {
    private RayTrace() {
    }

    public static RayTraceResult trace(@Nonnull EntityLivingBase entity) {
        double range = entity instanceof EntityPlayer ? entity.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : (double)(entity.field_70130_N * 2.0f + 0.6f);
        World world = entity.func_130014_f_();
        Vec3d eyes = entity.func_174824_e(1.0f);
        Vec3d look = entity.func_70676_i(1.0f);
        Vec3d rangedLook = eyes.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        RayTraceResult traceResult = RayTrace.rayTraceBlocks(world, eyes, rangedLook, false, false, true);
        Entity pointedEntity = null;
        boolean flag = false;
        double range1 = range;
        if (range > 3.0) {
            flag = true;
        }
        if (traceResult != null) {
            range1 = traceResult.field_72307_f.func_72438_d(eyes);
        }
        Vec3d hitLocation = null;
        List list = world.func_175674_a((Entity)entity, entity.func_174813_aQ().func_72321_a(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, e -> e != null && e.func_70067_L()));
        double d2 = range1;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(eyes, rangedLook);
            if (axisalignedbb.func_72318_a(eyes)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                hitLocation = raytraceresult == null ? eyes : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = eyes.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == entity.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                hitLocation = raytraceresult.field_72307_f;
                continue;
            }
            pointedEntity = entity1;
            hitLocation = raytraceresult.field_72307_f;
            d2 = d3;
        }
        if (pointedEntity != null && flag && eyes.func_72438_d(hitLocation) > 3.0) {
            pointedEntity = null;
            traceResult = new RayTraceResult(RayTraceResult.Type.MISS, hitLocation, (EnumFacing)null, new BlockPos(hitLocation));
        }
        if (pointedEntity != null && (d2 < range1 || traceResult == null)) {
            traceResult = new RayTraceResult(pointedEntity, hitLocation);
        }
        return traceResult;
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(@Nonnull World world, Vec3d vec31, Vec3d vec32, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        IBlockAccessEx provider = WorldUtils.getDefaultBlockStateProvider();
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c))) {
            if (!(Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathStuff.floor(vec32.field_72450_a);
                int j = MathStuff.floor(vec32.field_72448_b);
                int k = MathStuff.floor(vec32.field_72449_c);
                int l = MathStuff.floor(vec31.field_72450_a);
                int i1 = MathStuff.floor(vec31.field_72448_b);
                int j1 = MathStuff.floor(vec31.field_72449_c);
                blockpos.func_181079_c(l, i1, j1);
                IBlockState iblockstate = provider.func_180495_p((BlockPos)blockpos);
                Block block = iblockstate.func_177230_c();
                if ((!ignoreBlockWithoutBoundingBox || iblockstate.func_185890_d((IBlockAccess)world, (BlockPos)blockpos) != Block.field_185506_k) && block.func_176209_a(iblockstate, stopOnLiquid) && (raytraceresult = iblockstate.func_185910_a(world, (BlockPos)blockpos, vec31, vec32)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vec32.field_72450_a - vec31.field_72450_a;
                    double d7 = vec32.field_72448_b - vec31.field_72448_b;
                    double d8 = vec32.field_72449_c - vec31.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vec31.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vec31.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vec31.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vec31 = new Vec3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vec31 = new Vec3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                    }
                    l = MathStuff.floor(vec31.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathStuff.floor(vec31.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathStuff.floor(vec31.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos.func_181079_c(l, i1, j1);
                    iblockstate = provider.func_180495_p((BlockPos)blockpos);
                    block = iblockstate.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate.func_185904_a() != Material.field_151567_E && iblockstate.func_185890_d((IBlockAccess)world, (BlockPos)blockpos) == Block.field_185506_k) continue;
                    if (block.func_176209_a(iblockstate, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = iblockstate.func_185910_a(world, (BlockPos)blockpos, vec31, vec32);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vec31, enumfacing, (BlockPos)blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }
}

