/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import jeresources.api.drop.LootDrop;
import jeresources.compatibility.CompatBase;
import jeresources.util.FakeClientWorld;
import jeresources.util.MobTableBuilder;
import jeresources.util.ReflectionHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootTableHelper {
    private static final Map<EnumDyeColor, ResourceLocation> sheepColors = new HashMap<EnumDyeColor, ResourceLocation>();
    private static LootTableManager manager;

    public static List<LootPool> getPools(LootTable table) {
        return (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"field_186466_c");
    }

    public static List<LootEntry> getEntries(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186453_a");
    }

    public static List<LootCondition> getConditions(LootPool pool) {
        return (List)ReflectionHelper.getPrivateValue(LootPool.class, (Object)pool, (String)"field_186454_b");
    }

    public static Item getItem(LootEntryItem lootEntry) {
        return (Item)ReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String)"field_186368_a");
    }

    public static LootFunction[] getFunctions(LootEntryItem lootEntry) {
        return (LootFunction[])ReflectionHelper.getPrivateValue(LootEntryItem.class, (Object)lootEntry, (String)"field_186369_b");
    }

    public static List<LootDrop> toDrops(LootTable table) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LootTableManager manager = LootTableHelper.getManager();
        LootTableHelper.getPools(table).forEach(pool -> {
            float totalWeight = LootTableHelper.getEntries(pool).stream().mapToInt(entry -> entry.func_186361_a(0.0f)).sum();
            List<LootCondition> poolConditions = LootTableHelper.getConditions(pool);
            LootTableHelper.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryItem).map(entry -> (LootEntryItem)entry).map(entry -> new LootDrop(LootTableHelper.getItem(entry), (float)entry.func_186361_a(0.0f) / totalWeight, entry.field_186366_e, LootTableHelper.getFunctions(entry))).map(drop -> drop.addLootConditions(poolConditions)).forEach(drops::add);
            LootTableHelper.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryTable).map(entry -> (LootEntryTable)entry).map(entry -> LootTableHelper.toDrops(manager.func_186521_a(entry.field_186371_a))).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootDrop> toDrops(World world, ResourceLocation lootTable) {
        return LootTableHelper.toDrops(LootTableHelper.getManager(world).func_186521_a(lootTable));
    }

    public static List<ResourceLocation> getAllChestLootTablesResourceLocations() {
        ArrayList<ResourceLocation> chestTables = new ArrayList<ResourceLocation>();
        chestTables.add(LootTableList.field_186421_c);
        chestTables.add(LootTableList.field_186422_d);
        chestTables.add(LootTableList.field_186423_e);
        chestTables.add(LootTableList.field_186424_f);
        chestTables.add(LootTableList.field_186425_g);
        chestTables.add(LootTableList.field_186426_h);
        chestTables.add(LootTableList.field_186427_i);
        chestTables.add(LootTableList.field_186428_j);
        chestTables.add(LootTableList.field_186429_k);
        chestTables.add(LootTableList.field_186430_l);
        chestTables.add(LootTableList.field_186431_m);
        chestTables.add(LootTableList.field_191192_o);
        return chestTables;
    }

    public static Map<ResourceLocation, EntityLivingBase> getAllMobLootTables(World world) {
        MobTableBuilder mobTableBuilder = new MobTableBuilder(world);
        mobTableBuilder.add(LootTableList.field_186432_n, EntityWitch.class);
        mobTableBuilder.add(LootTableList.field_186433_o, EntityBlaze.class);
        mobTableBuilder.add(LootTableList.field_186434_p, EntityCreeper.class);
        mobTableBuilder.add(LootTableList.field_186435_q, EntitySpider.class);
        mobTableBuilder.add(LootTableList.field_186436_r, EntityCaveSpider.class);
        mobTableBuilder.add(LootTableList.field_186437_s, EntityGiantZombie.class);
        mobTableBuilder.add(LootTableList.field_186438_t, EntitySilverfish.class);
        mobTableBuilder.add(LootTableList.field_186439_u, EntityEnderman.class);
        mobTableBuilder.add(LootTableList.field_186440_v, EntityGuardian.class);
        mobTableBuilder.add(LootTableList.field_186441_w, EntityElderGuardian.class);
        mobTableBuilder.add(LootTableList.field_186442_x, EntityShulker.class);
        mobTableBuilder.add(LootTableList.field_186443_y, EntityIronGolem.class);
        mobTableBuilder.add(LootTableList.field_186444_z, EntitySnowman.class);
        mobTableBuilder.add(LootTableList.field_186393_A, EntityRabbit.class);
        mobTableBuilder.add(LootTableList.field_186394_B, EntityChicken.class);
        mobTableBuilder.add(LootTableList.field_186395_C, EntityPig.class);
        mobTableBuilder.add(LootTableList.field_186396_D, EntityHorse.class);
        mobTableBuilder.add(LootTableList.field_191190_H, EntityDonkey.class);
        mobTableBuilder.add(LootTableList.field_191191_I, EntityMule.class);
        mobTableBuilder.add(LootTableList.field_186397_E, EntityZombieHorse.class);
        mobTableBuilder.add(LootTableList.field_186398_F, EntitySkeletonHorse.class);
        mobTableBuilder.add(LootTableList.field_186399_G, EntityCow.class);
        mobTableBuilder.add(LootTableList.field_186400_H, EntityMooshroom.class);
        mobTableBuilder.add(LootTableList.field_186401_I, EntityWolf.class);
        mobTableBuilder.add(LootTableList.field_186402_J, EntityOcelot.class);
        for (Map.Entry<EnumDyeColor, ResourceLocation> entry : sheepColors.entrySet()) {
            ResourceLocation lootTableList = entry.getValue();
            EnumDyeColor dyeColor = entry.getKey();
            mobTableBuilder.add(lootTableList, EntitySheep.class, entity -> entity.func_175512_b(dyeColor));
        }
        mobTableBuilder.add(LootTableList.field_186377_ab, EntityBat.class);
        mobTableBuilder.add(LootTableList.field_186378_ac, EntitySlime.class);
        mobTableBuilder.add(LootTableList.field_186379_ad, EntityMagmaCube.class);
        mobTableBuilder.add(LootTableList.field_186380_ae, EntityGhast.class);
        mobTableBuilder.add(LootTableList.field_186381_af, EntitySquid.class);
        mobTableBuilder.add(LootTableList.field_186382_ag, EntityEndermite.class);
        mobTableBuilder.add(LootTableList.field_186383_ah, EntityZombie.class);
        mobTableBuilder.add(LootTableList.field_186384_ai, EntityPigZombie.class);
        mobTableBuilder.add(LootTableList.field_186385_aj, EntitySkeleton.class);
        mobTableBuilder.add(LootTableList.field_186386_ak, EntityWitherSkeleton.class);
        mobTableBuilder.add(LootTableList.field_189968_an, EntityStray.class);
        mobTableBuilder.add(LootTableList.field_191182_ar, EntityHusk.class);
        mobTableBuilder.add(LootTableList.field_191183_as, EntityZombieVillager.class);
        mobTableBuilder.add(LootTableList.field_191184_at, EntityVillager.class);
        mobTableBuilder.add(LootTableList.field_191185_au, EntityEvoker.class);
        mobTableBuilder.add(LootTableList.field_191186_av, EntityVindicator.class);
        mobTableBuilder.add(LootTableList.field_191187_aw, EntityLlama.class);
        mobTableBuilder.add(LootTableList.field_191188_ax, EntityVex.class);
        mobTableBuilder.add(LootTableList.field_191189_ay, EntityDragon.class);
        mobTableBuilder.add(LootTableList.field_192561_ax, EntityParrot.class);
        return mobTableBuilder.getMobTables();
    }

    public static LootTableManager getManager(@Nullable World world) {
        if (world == null || world.func_184146_ak() == null) {
            if (manager == null) {
                FakeClientWorld.FakeSaveHandler saveHandler = FakeClientWorld.saveHandler;
                manager = new LootTableManager(new File(new File(saveHandler.func_75765_b(), "data"), "loot_tables"));
            }
            return manager;
        }
        return world.func_184146_ak();
    }

    public static LootTableManager getManager() {
        return LootTableHelper.getManager(CompatBase.getWorld());
    }

    static {
        sheepColors.put(EnumDyeColor.WHITE, LootTableList.field_186404_L);
        sheepColors.put(EnumDyeColor.ORANGE, LootTableList.field_186405_M);
        sheepColors.put(EnumDyeColor.MAGENTA, LootTableList.field_186406_N);
        sheepColors.put(EnumDyeColor.LIGHT_BLUE, LootTableList.field_186407_O);
        sheepColors.put(EnumDyeColor.YELLOW, LootTableList.field_186408_P);
        sheepColors.put(EnumDyeColor.LIME, LootTableList.field_186409_Q);
        sheepColors.put(EnumDyeColor.PINK, LootTableList.field_186410_R);
        sheepColors.put(EnumDyeColor.GRAY, LootTableList.field_186411_S);
        sheepColors.put(EnumDyeColor.SILVER, LootTableList.field_186412_T);
        sheepColors.put(EnumDyeColor.CYAN, LootTableList.field_186413_U);
        sheepColors.put(EnumDyeColor.PURPLE, LootTableList.field_186414_V);
        sheepColors.put(EnumDyeColor.BLUE, LootTableList.field_186415_W);
        sheepColors.put(EnumDyeColor.BROWN, LootTableList.field_186416_X);
        sheepColors.put(EnumDyeColor.GREEN, LootTableList.field_186417_Y);
        sheepColors.put(EnumDyeColor.RED, LootTableList.field_186418_Z);
        sheepColors.put(EnumDyeColor.BLACK, LootTableList.field_186376_aa);
    }
}

