/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jeresources.api.drop.PlantDrop;
import jeresources.util.MapKeys;
import jeresources.util.SeedHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;

public class PlantEntry {
    private IPlantable plant;
    private ItemStack plantStack;
    private Map<String, PlantDrop> drops = new LinkedHashMap<String, PlantDrop>();
    private int totalWeight = 0;
    private IBlockState soil = null;

    public static PlantEntry registerGrass() {
        List<PlantDrop> seeds = SeedHelper.getSeeds();
        PlantEntry grass = new PlantEntry(new ItemStack((Block)Blocks.field_150329_H, 1, 1), seeds.toArray(new PlantDrop[seeds.size()]));
        grass.totalWeight *= 8;
        return grass;
    }

    public IBlockState getSoil() {
        return this.soil;
    }

    public void setSoil(IBlockState soil) {
        this.soil = soil;
    }

    public PlantEntry(ItemStack itemStack, IPlantable plant, PlantDrop ... drops) {
        this.plantStack = itemStack;
        this.plant = plant;
        for (PlantDrop entry : drops) {
            this.totalWeight += entry.getWeight();
            String key = MapKeys.getKey(entry.getDrop());
            if (key == null) continue;
            this.drops.put(key, entry);
        }
    }

    public PlantEntry(ItemStack itemStack, PlantDrop ... drops) {
        this(itemStack, (IPlantable)null, drops);
    }

    public <T extends Item> PlantEntry(T plant, PlantDrop ... drops) {
        this(new ItemStack(plant), (IPlantable)plant, drops);
    }

    public void add(PlantDrop entry) {
        String key = MapKeys.getKey(entry.getDrop());
        if (!this.drops.containsKey(key)) {
            return;
        }
        this.drops.put(key, new PlantDrop(entry.getDrop(), this.totalWeight + entry.getWeight()));
    }

    public IPlantable getPlant() {
        return this.plant;
    }

    public ItemStack getPlantItemStack() {
        return this.plantStack;
    }

    public List<PlantDrop> getDrops() {
        return new ArrayList<PlantDrop>(this.drops.values());
    }

    public List<ItemStack> getLootDropStacks() {
        return this.getDrops().stream().map(PlantDrop::getDrop).collect(Collectors.toList());
    }

    public PlantDrop getDrop(ItemStack itemStack) {
        return this.drops.get(MapKeys.getKey(itemStack));
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }
}

