/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.world.data;

import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.world.data.ChunkData;
import com.zeitheron.hammercore.world.data.ChunkDataProvider;
import com.zeitheron.hammercore.world.data.IChunkData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MCFBus
public class PerChunkDataManager {
    @CapabilityInject(value=IChunkData.class)
    public static Capability<IChunkData> CHUNK_DATA;

    public static void register() {
        CapabilityManager.INSTANCE.register(IChunkData.class, (Capability.IStorage)new Capability.IStorage<IChunkData>(){

            public NBTBase writeNBT(Capability<IChunkData> capability, IChunkData instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IChunkData> capability, IChunkData instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTBase)((NBTTagCompound)instance));
            }
        }, () -> new ChunkData());
    }

    public static IChunkData getData(Chunk chunk) {
        return (IChunkData)chunk.getCapability(CHUNK_DATA, null);
    }

    @SubscribeEvent
    public void attachCaps(AttachCapabilitiesEvent<Chunk> e) {
        e.addCapability(new ResourceLocation("hammercore", "data"), (ICapabilityProvider)new ChunkDataProvider());
    }

    public static String build(Chunk c) {
        return c.func_177412_p().field_73011_w.getDimension() + ":" + c.field_76635_g + "," + c.field_76647_h;
    }
}

