/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.recipes.helper;

import com.zeitheron.hammercore.internal.SimpleRegistration;
import com.zeitheron.hammercore.utils.recipes.helper.RegisterRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.OreDictionary;

public abstract class RecipeRegistry {
    protected List<IRecipe> recipes = new ArrayList<IRecipe>();

    public abstract void crafting();

    public void smelting() {
    }

    @Deprecated
    public void oredict() {
    }

    public static ItemStack enchantedBook(Enchantment ench, int lvl) {
        ItemStack book = new ItemStack(Items.field_151134_bR);
        HashMap<Enchantment, Integer> enchs = new HashMap<Enchantment, Integer>();
        enchs.put(ench, lvl);
        EnchantmentHelper.func_82782_a(enchs, (ItemStack)book);
        return book;
    }

    public static ItemStack potionItemNormal(PotionType ... types) {
        ItemStack po = new ItemStack((Item)Items.field_151068_bn);
        for (PotionType type : types) {
            PotionUtils.func_185188_a((ItemStack)po, (PotionType)type);
        }
        return po;
    }

    public static ItemStack potionItemSplash(PotionType ... types) {
        ItemStack po = new ItemStack((Item)Items.field_185155_bH);
        for (PotionType type : types) {
            PotionUtils.func_185188_a((ItemStack)po, (PotionType)type);
        }
        return po;
    }

    public static ItemStack potionItemLingering(PotionType ... types) {
        ItemStack po = new ItemStack((Item)Items.field_185156_bI);
        for (PotionType type : types) {
            PotionUtils.func_185188_a((ItemStack)po, (PotionType)type);
        }
        return po;
    }

    public Collection<IRecipe> collect() {
        this.recipes = new ArrayList<IRecipe>();
        this.crafting();
        HashSet<IRecipe> recipes = new HashSet<IRecipe>(this.recipes);
        this.recipes = null;
        return recipes;
    }

    protected void smelting(ItemStack in, ItemStack out) {
        this.smelting(in, out, 0.0f);
    }

    protected void oredict(String od, Item i) {
        OreDictionary.registerOre((String)od, (Item)i);
    }

    protected void oredict(String od, Block b) {
        OreDictionary.registerOre((String)od, (Block)b);
    }

    protected void oredict(String od, ItemStack s) {
        OreDictionary.registerOre((String)od, (ItemStack)s);
    }

    protected void smelting(Item in, ItemStack out, float xp) {
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(in), out, xp);
    }

    protected void smelting(ItemStack in, ItemStack out, float xp) {
        FurnaceRecipes.func_77602_a().func_151394_a(in, out, xp);
    }

    protected IRecipe shaped(ItemStack out, Object ... recipeComponents) {
        return this.recipe((IRecipe)SimpleRegistration.parseShapedRecipe(out, recipeComponents));
    }

    protected IRecipe shaped(Item out, Object ... recipeComponents) {
        return this.recipe((IRecipe)SimpleRegistration.parseShapedRecipe(new ItemStack(out), recipeComponents));
    }

    protected IRecipe shaped(Block out, Object ... recipeComponents) {
        return this.recipe((IRecipe)SimpleRegistration.parseShapedRecipe(new ItemStack(out), recipeComponents));
    }

    protected IRecipe shapeless(ItemStack out, Object ... recipeComponents) {
        return this.recipe((IRecipe)SimpleRegistration.parseShapelessRecipe(out, recipeComponents));
    }

    protected IRecipe shapeless(Item out, Object ... recipeComponents) {
        return this.recipe((IRecipe)SimpleRegistration.parseShapelessRecipe(new ItemStack(out), recipeComponents));
    }

    protected IRecipe shapeless(Block out, Object ... recipeComponents) {
        return this.recipe((IRecipe)SimpleRegistration.parseShapelessRecipe(new ItemStack(out), recipeComponents));
    }

    protected String getMod() {
        RegisterRecipes a = this.getClass().getAnnotation(RegisterRecipes.class);
        return a != null ? a.modid() : "unknown";
    }

    public ModContainer getOwner() {
        return (ModContainer)Loader.instance().getIndexedModList().get(this.getMod());
    }

    protected IRecipe recipe(IRecipe recipe) {
        if (recipe.getRegistryName() == null) {
            recipe = (IRecipe)recipe.setRegistryName(new ResourceLocation("hammercore", this.getMod() + "_" + this.getClass().getSimpleName() + "." + this.recipes.size()));
        }
        this.recipes.add(recipe);
        return recipe;
    }
}

