/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.raytracer;

import com.zeitheron.hammercore.utils.math.vec.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public class ExtendedRayTraceResult
extends RayTraceResult
implements Comparable<ExtendedRayTraceResult> {
    public double dist;

    public ExtendedRayTraceResult(Entity entity, Vector3 hit, Object data, double dist) {
        super(entity, hit.vec3());
        this.setData(data);
        this.dist = dist;
    }

    public ExtendedRayTraceResult(Vector3 hit, int side, BlockPos pos, Object data, double dist) {
        super(hit.vec3(), EnumFacing.values()[side], pos);
        this.setData(data);
        this.dist = dist;
    }

    public ExtendedRayTraceResult(Vector3 hit, EnumFacing side, BlockPos pos, Object data, double dist) {
        super(hit.vec3(), side, pos);
        this.setData(data);
        this.dist = dist;
    }

    public void setData(Object data) {
        if (data instanceof Integer) {
            this.subHit = (Integer)data;
        }
        this.hitInfo = data;
    }

    @Override
    public int compareTo(ExtendedRayTraceResult o) {
        return this.dist == o.dist ? 0 : (this.dist < o.dist ? -1 : 1);
    }
}

