/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.transport;

import com.google.common.base.Predicates;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.transport.ITransportAcceptor;
import com.zeitheron.hammercore.net.transport.NetTransport;
import com.zeitheron.hammercore.net.transport.PacketTransportInfo;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.thread.SidedThreadGroup;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.relauncher.Side;

public class TransportSession {
    final Class<? extends ITransportAcceptor> acceptor;
    final List<byte[]> pending;
    final ITransportAcceptor acceptori;
    final PipedOutputStream pos;
    final PipedInputStream pis;
    public final String id;
    final int length;
    final Side createSide;

    public TransportSession(String id, Class<? extends ITransportAcceptor> acceptor, List<byte[]> data, ITransportAcceptor ai, int length) {
        this.id = id;
        this.acceptor = acceptor;
        this.pending = data;
        this.acceptori = ai;
        this.length = length;
        this.createSide = FMLCommonHandler.instance().getEffectiveSide();
        PipedInputStream pis = null;
        PipedOutputStream pos = null;
        if (ai != null) {
            pis = new PipedInputStream(length);
            try {
                pos = new PipedOutputStream(pis);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.pis = pis;
        this.pos = pos;
        if (ai != null) {
            SidedThreadGroup stg = this.createSide == Side.SERVER ? SidedThreadGroups.SERVER : SidedThreadGroups.CLIENT;
            Thread t = stg.newThread(() -> ai.read(this.pis, length));
            t.start();
            NetTransport.indexSession(this);
        }
    }

    PacketTransportInfo genPacket() {
        NetTransport.indexSession(this);
        return new PacketTransportInfo(this.id, this.acceptor.getName(), this.length);
    }

    public PacketTransportInfo createPacket() {
        return TransportSession.genCopy(this).genPacket();
    }

    public void sendTo(EntityPlayerMP player) {
        HCNet.INSTANCE.sendTo(this.createPacket(), player);
    }

    public void sendToServer() {
        HCNet.INSTANCE.sendToServer(this.createPacket());
    }

    @Deprecated
    public void sendToAll(EntityPlayerMP player) {
        this.sendToAll();
    }

    public void sendToAll() {
        this.sendToPlayersIf((Predicate<EntityPlayerMP>)Predicates.alwaysTrue());
    }

    public void sendToDimension(int dim) {
        this.sendToPlayersIf(mp -> mp.field_70170_p.field_73011_w.getDimension() == dim);
    }

    public void sendToNearby(NetworkRegistry.TargetPoint tp) {
        this.sendToPlayersIf(mp -> mp.field_70170_p.field_73011_w.getDimension() == tp.dimension && Math.sqrt(mp.func_174791_d().func_186679_c(tp.x, tp.y, tp.z)) <= tp.range);
    }

    public void sendToPlayersIf(Predicate<EntityPlayerMP> predicate) {
        MinecraftServer mcs = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (mcs != null) {
            for (EntityPlayerMP mp : mcs.func_184103_al().func_181057_v()) {
                if (!predicate.test(mp)) continue;
                this.sendTo(mp);
            }
        }
    }

    public void sendToMultiplePlayers(EntityPlayerMP ... players) {
        for (int i = 0; i < players.length; ++i) {
            this.sendTo(players[i]);
        }
    }

    void accept(byte[] data) {
        if (this.pos != null) {
            try {
                this.pos.write(data);
                this.pos.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void end() {
        Map<String, TransportSession> m = NetTransport.SESSIONS.get(this.createSide);
        if (m != null) {
            m.remove(this.id);
        }
    }

    public static TransportSession genCopy(TransportSession session) {
        ArrayList<byte[]> matrix2 = new ArrayList<byte[]>(session.pending);
        for (int i = 0; i < matrix2.size(); ++i) {
            matrix2.set(i, (byte[])((byte[])matrix2.get(i)).clone());
        }
        return new TransportSession(UUID.randomUUID().toString(), session.acceptor, matrix2, null, session.length);
    }
}

