/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.io;

import com.zeitheron.hammercore.lib.zlib.error.JSONException;
import com.zeitheron.hammercore.lib.zlib.io.MultiOutputStream;
import com.zeitheron.hammercore.lib.zlib.io.cache.ICacher;
import com.zeitheron.hammercore.lib.zlib.io.cache.VoidCacher;
import com.zeitheron.hammercore.lib.zlib.json.JSONTokener;
import com.zeitheron.hammercore.lib.zlib.tuple.TwoTuple;
import com.zeitheron.hammercore.lib.zlib.utils.Joiner;
import com.zeitheron.hammercore.lib.zlib.web.HttpRequest;
import com.zeitheron.hammercore.utils.classes.ClassWrapper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;

public class IOUtils {
    public static final ICacher cache = new VoidCacher();
    public static final DecimalFormat lenform = new DecimalFormat("#0.00");
    public static int heapLimit = 4096;
    public static final byte[] ZERO_ARRAY = new byte[0];
    private static final ThreadLocal<byte[]> buf = ThreadLocal.withInitial(new Supplier<byte[]>(){

        @Override
        public byte[] get() {
            return new byte[heapLimit];
        }
    });

    public static Object jsonparse(File file) throws JSONException {
        return new JSONTokener(IOUtils.ioget(file)).nextValue();
    }

    public static Object downloadjson(String url) throws JSONException {
        return new JSONTokener(IOUtils.ioget(url)).nextValue();
    }

    public static Object downloadjsonOrLoadFromInternal(String url, String path) throws JSONException {
        String data = IOUtils.ioget(url);
        if (data.isEmpty()) {
            data = new String(IOUtils.pipeOut(ClassWrapper.getCallerClass().getResourceAsStream(path)));
        }
        return data.isEmpty() ? null : new JSONTokener(data).nextValue();
    }

    public static String ioget(File file) {
        if (file.isFile()) {
            try {
                return Joiner.NEW_LINE.join(Files.readAllLines(file.toPath()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String ioget(String url) {
        return new String(IOUtils.downloadData(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage downloadPicture(String url) {
        try (InputStream in = HttpRequest.get(url).userAgent("HammerCore/2.0.6.23").stream();){
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    public static byte[] downloadData(String url) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.downloadAndWriteData(url, baos);
            byte[] buf = baos.toByteArray();
            return buf;
        }
        catch (Throwable baos) {
            return ZERO_ARRAY;
        }
    }

    public static void downloadAndWriteData(String url, OutputStream o) {
        InputStream internet = null;
        boolean live = false;
        if (!cache.preventLiveConnection(url)) {
            try {
                URL u = new URL(url);
                internet = u.openStream();
                live = true;
            }
            catch (Throwable u) {
                // empty catch block
            }
        }
        if (internet == null && cache.isActuallyWorking()) {
            internet = cache.pull(url);
        }
        if (internet != null) {
            try {
                if (live) {
                    OutputStream ao;
                    OutputStream outputStream = ao = cache.isActuallyWorking() ? cache.put(url) : null;
                    if (ao == null) {
                        IOUtils.pipeData(internet, o);
                    } else {
                        IOUtils.pipeData(internet, new MultiOutputStream(o, ao));
                        ao.close();
                    }
                } else {
                    IOUtils.pipeData(internet, o);
                }
                internet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void pipeData(InputStream from, OutputStream to) {
        try {
            byte[] buf = IOUtils.buf.get();
            int read = 0;
            while ((read = from.read(buf)) > 0) {
                to.write(buf, 0, read);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static byte[] pipeOut(InputStream from) {
        ByteArrayOutputStream to = new ByteArrayOutputStream();
        IOUtils.pipeData(from, to);
        return to.toByteArray();
    }

    public static byte[] pipeOutAvaliable(InputStream from) {
        try {
            byte[] buf = new byte[from.available()];
            from.read(buf);
            return buf;
        }
        catch (Throwable buf) {
            return ZERO_ARRAY;
        }
    }

    public static byte[] deflaterCompress(byte[] data) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream o = new DeflaterOutputStream((OutputStream)baos, new Deflater(9));
            o.write(data);
            o.close();
            return baos.toByteArray();
        }
        catch (Throwable baos) {
            return ZERO_ARRAY;
        }
    }

    public static byte[] deflaterUncompress(byte[] data) {
        try {
            InflaterInputStream i = new InflaterInputStream(new ByteArrayInputStream(data), new Inflater());
            data = IOUtils.pipeOut(i);
            i.close();
            return data;
        }
        catch (Throwable i) {
            return ZERO_ARRAY;
        }
    }

    public static TwoTuple<InputStream, Boolean> getInput(String url) {
        InputStream internet = null;
        boolean live = false;
        if (!cache.preventLiveConnection(url)) {
            try {
                URL u = new URL(url);
                internet = u.openStream();
                live = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (internet == null) {
            internet = cache.pull(url);
        }
        return new TwoTuple<InputStream, Boolean>(internet, live);
    }

    public static long size(File file) {
        if (file.isFile()) {
            try {
                return Files.size(file.toPath());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        long size = 0L;
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                size += IOUtils.size(f);
            }
        }
        return size;
    }

    public static String getFormattedFileSize(long size) {
        if (size == -1L) {
            return "?";
        }
        long B = size;
        double KB = (double)size / 1024.0;
        double MB = KB / 1024.0;
        double GB = MB / 1024.0;
        double TB = GB / 1024.0;
        return B < 1024L ? B + " B" : (KB < 1024.0 ? lenform.format(KB) + " KB" : (MB < 1024.0 ? lenform.format(MB) + " MB" : (GB < 1024.0 ? lenform.format(GB) + " GB" : lenform.format(TB) + " TB")));
    }

    public static String followRedirects(String url) throws IOException {
        String u;
        URL obj = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setReadTimeout(5000);
        conn.addRequestProperty("Accept-Language", "en-US,en;q=0.8");
        conn.addRequestProperty("User-Agent", "Mozilla");
        conn.addRequestProperty("Referer", "google.com");
        boolean redirect = false;
        int status = conn.getResponseCode();
        if (status != 200 && (status == 302 || status == 301 || status == 303)) {
            redirect = true;
        }
        if (redirect) {
            String newUrl = conn.getHeaderField("Location");
            String cookies = conn.getHeaderField("Set-Cookie");
            conn = (HttpURLConnection)new URL(newUrl).openConnection();
            conn.setRequestProperty("Cookie", cookies);
            conn.addRequestProperty("Accept-Language", "en-US,en;q=0.8");
            conn.addRequestProperty("User-Agent", "Mozilla");
            conn.addRequestProperty("Referer", "google.com");
        }
        return (u = conn.getHeaderField("Location")) != null ? u : url;
    }

    public static File pickFile(File f) {
        if (f.isFile()) {
            String ext = f.getName().contains(".") ? f.getName().substring(f.getName().lastIndexOf(".")) : "";
            String name = f.getName().contains(".") ? f.getAbsolutePath().substring(0, f.getAbsolutePath().lastIndexOf(".")) : f.getAbsolutePath();
            int i = 1;
            while (true) {
                File nf;
                if (!(nf = new File(name + " (" + i + ")" + ext)).isFile()) {
                    return nf;
                }
                ++i;
            }
        }
        if (f.isDirectory()) {
            String name = f.getAbsolutePath();
            int i = 1;
            while (true) {
                File nf;
                if (!(nf = new File(name + " (" + i + ")")).isDirectory()) {
                    return nf;
                }
                ++i;
            }
        }
        return f;
    }
}

