/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.image;

import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public interface Icon {
    public static final Map<String, Icon> urlIcons = new HashMap<String, Icon>();

    public static Icon of(BufferedImage buf) {
        if (buf == null) {
            return null;
        }
        return () -> buf;
    }

    public static Icon of(final BufferedImage buf, final int delay) {
        return new Icon(){

            @Override
            public BufferedImage buffer() {
                return buf;
            }

            @Override
            public int delay() {
                return delay;
            }
        };
    }

    public static Icon of(String url) {
        if (urlIcons.containsKey(url)) {
            return urlIcons.get(url);
        }
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                Icon ico = Icon.of(ImageIO.read(new ByteArrayInputStream(IOUtils.downloadData(url))));
                urlIcons.put(url, ico);
                return ico;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Icon.of(new File(url));
    }

    public static Icon of(File file) {
        BufferedImage buf;
        try {
            buf = ImageIO.read(file);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return Icon.of(buf);
    }

    public BufferedImage buffer();

    default public int delay() {
        return 250;
    }

    default public int width() {
        return this.buffer() == null ? 0 : this.buffer().getWidth();
    }

    default public int height() {
        return this.buffer() == null ? 0 : this.buffer().getHeight();
    }

    default public Icon round(int arcX, int arcY) {
        BufferedImage buf = this.buffer();
        BufferedImage out = new BufferedImage(this.width(), this.height(), 2);
        out.createGraphics().drawImage((Image)buf, 0, 0, null);
        BufferedImage round = new BufferedImage(this.width(), this.height(), 2);
        Graphics2D g2d = round.createGraphics();
        g2d.setColor(Color.BLACK);
        g2d.fillRoundRect(0, 0, this.width(), this.height(), arcX, arcY);
        for (int x = 0; x < this.width(); ++x) {
            for (int y = 0; y < this.height(); ++y) {
                if ((round.getRGB(x, y) >> 88 & 0xFF) >= 5) continue;
                out.getRaster().setPixel(x, y, new int[]{255, 255, 255, 0});
            }
        }
        return Icon.of(out);
    }

    default public Icon brighter(int points) {
        Icon ic = this.copy();
        RescaleOp rescaleOp = new RescaleOp(1.2f, points, null);
        rescaleOp.filter(ic.buffer(), ic.buffer());
        return ic;
    }

    default public Icon copy() {
        if (this.buffer() == null) {
            return this;
        }
        BufferedImage buf = this.buffer();
        BufferedImage out = new BufferedImage(this.width(), this.height(), buf.getType());
        out.createGraphics().drawImage((Image)buf, 0, 0, null);
        return Icon.of(out);
    }

    default public Icon resize(int width, int height) {
        if (this.width() == width && this.height() == height) {
            return this;
        }
        BufferedImage buf = this.buffer();
        BufferedImage scaled = new BufferedImage(width, height, buf.getType());
        scaled.createGraphics().drawImage(buf, 0, 0, width, height, null);
        return Icon.of(scaled, this.delay());
    }

    default public Icon sub(int x, int y, int width, int height) {
        return Icon.of(this.buffer().getSubimage(x, y, width, height), this.delay());
    }
}

