/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.cfg.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class HCConfigGui
extends GuiConfig {
    public HCConfigGui(GuiScreen prev, Configuration cfg, String modid) {
        super(prev, HCConfigGui.getElements(cfg), modid, HCConfigGui.allRequireWorldRestart(cfg), HCConfigGui.allRequireMcRestart(cfg), HCConfigGui.getAbridgedConfigPath((String)cfg.toString()));
        ModContainer mc = HCConfigGui.getContainerByID(modid);
        this.title = "Config GUI for " + (mc != null ? mc.getName() : "Unknown mod");
        File configs = new File("config");
        File c = new File(cfg.toString());
        this.titleLine2 = c.getAbsolutePath().substring(configs.getAbsolutePath().length() + 1);
    }

    public static ModContainer getContainerByID(String modid) {
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            if (!mc.getModId().equals(modid)) continue;
            return mc;
        }
        return null;
    }

    public static boolean allRequireWorldRestart(Configuration cfg) {
        for (String cat : cfg.getCategoryNames()) {
            if (cfg.getCategory(cat).requiresWorldRestart()) continue;
            return false;
        }
        return true;
    }

    public static boolean allRequireMcRestart(Configuration cfg) {
        for (String cat : cfg.getCategoryNames()) {
            if (cfg.getCategory(cat).requiresMcRestart()) continue;
            return false;
        }
        return true;
    }

    public static List<IConfigElement> getElements(Configuration cfg) {
        ArrayList<IConfigElement> a = new ArrayList<IConfigElement>();
        for (String cat : cfg.getCategoryNames()) {
            a.add((IConfigElement)new ConfigElement(cfg.getCategory(cat)));
        }
        return a;
    }
}

