/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.mhb;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.MultiHitboxGetter;
import com.zeitheron.hammercore.raytracer.IndexedCuboid6;
import com.zeitheron.hammercore.raytracer.RayTracer;
import com.zeitheron.hammercore.utils.math.vec.Cuboid6;
import com.zeitheron.hammercore.utils.math.vec.Vector3;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public abstract class BlockTraceable
extends Block {
    public static EnumFacing current_face = EnumFacing.DOWN;
    protected final RayTracer RayTracer = new RayTracer();
    private boolean exited = true;

    public BlockTraceable(Material material) {
        super(material);
    }

    public BlockTraceable(Material material, MapColor mapColor) {
        super(material, mapColor);
    }

    public AxisAlignedBB getFullBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return field_185505_j;
    }

    public boolean includeAllHitboxes(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getFullBoundingBox(world, pos, state);
    }

    public boolean onBoxActivated(int boxID, Cuboid6 box, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean canSeeCouboid(World w, BlockPos p, int boxID, Cuboid6 box, Vector3 start, Vector3 end) {
        return this.RayTracer.rayTraceCuboid(start, end, box);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        RayTraceResult hit = com.zeitheron.hammercore.raytracer.RayTracer.retraceBlock(worldIn, playerIn, pos);
        int boxID = hit != null ? Math.max(0, hit.subHit) : 0;
        Cuboid6[] boxes = this.getCurrentCuboids(worldIn, pos);
        Cuboid6 box = boxes != null && boxes.length > 0 ? boxes[hit != null ? Math.max(0, Math.min(hit.subHit, boxes.length - 1)) : 0] : null;
        return this.onBoxActivated(boxID, box, worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public final Cuboid6[] getCurrentCuboids(World world, BlockPos pos) {
        Cuboid6[] boxes = MultiHitboxGetter.getCuboidsAt(world, pos);
        return boxes == null || boxes.length == 0 ? null : boxes;
    }

    public final AxisAlignedBB func_180640_a(IBlockState s, World w, BlockPos p) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return this.selectAxis(s, w, p, HammerCore.renderProxy.getClientPlayer());
        }
        return field_185505_j;
    }

    protected final AxisAlignedBB selectAxis(IBlockState s, World w, BlockPos p, EntityPlayer player) {
        if (player == null) {
            return this.getFullBoundingBox((IBlockAccess)w, p, s);
        }
        RayTraceResult hit = com.zeitheron.hammercore.raytracer.RayTracer.retraceBlock(w, player, p);
        AxisAlignedBB aabb = this.getFullBoundingBox((IBlockAccess)w, p, s);
        Cuboid6[] boxes = this.getCurrentCuboids(w, p);
        if (hit != null && boxes != null && hit.subHit >= 0 && hit.subHit < boxes.length) {
            current_face = hit.field_178784_b;
            aabb = new AxisAlignedBB(boxes[hit.subHit].min.x + (double)p.func_177958_n(), boxes[hit.subHit].min.y + (double)p.func_177956_o(), boxes[hit.subHit].min.z + (double)p.func_177952_p(), boxes[hit.subHit].max.x + (double)p.func_177958_n(), boxes[hit.subHit].max.y + (double)p.func_177956_o(), boxes[hit.subHit].max.z + (double)p.func_177952_p());
        }
        return aabb;
    }

    public void func_185477_a(IBlockState s, World w, BlockPos p, AxisAlignedBB aabb, List<AxisAlignedBB> l, Entity ent, boolean wut) {
        if (!this.includeAllHitboxes(w, p, s)) {
            super.func_185477_a(s, w, p, aabb, l, ent, wut);
            return;
        }
        Cuboid6[] boxes = this.getCurrentCuboids(w, p);
        if (boxes != null) {
            for (Cuboid6 c : boxes) {
                BlockTraceable.func_185492_a((BlockPos)p, (AxisAlignedBB)aabb, l, (AxisAlignedBB)c.aabb());
            }
        }
    }

    public final RayTraceResult func_180636_a(IBlockState s, World world, BlockPos p, Vec3d start, Vec3d end) {
        this.exited = false;
        LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
        Cuboid6[] cbs = this.getCurrentCuboids(world, p);
        if (cbs == null) {
            return super.func_180636_a(s, world, p, start, end);
        }
        if (cbs != null) {
            for (int i = 0; i < cbs.length; ++i) {
                Cuboid6 c = cbs[i];
                Cuboid6 cc = new Cuboid6(c.aabb().field_72340_a + (double)p.func_177958_n(), c.aabb().field_72338_b + (double)p.func_177956_o(), c.aabb().field_72339_c + (double)p.func_177952_p(), c.aabb().field_72336_d + (double)p.func_177958_n(), c.aabb().field_72337_e + (double)p.func_177956_o(), c.aabb().field_72334_f + (double)p.func_177952_p());
                if (!this.canSeeCouboid(world, p, i, cc, new Vector3(start), new Vector3(end))) continue;
                cuboids.add(new IndexedCuboid6(i, c));
            }
        }
        this.exited = true;
        return com.zeitheron.hammercore.raytracer.RayTracer.rayTraceCuboidsClosest(new Vector3(start), new Vector3(end), p, cuboids);
    }

    public Cuboid6 getCuboidFromPlayer(EntityPlayer player, BlockPos pos) {
        RayTraceResult hit = com.zeitheron.hammercore.raytracer.RayTracer.retraceBlock(player.field_70170_p, player, pos);
        Cuboid6[] cubes = this.getCurrentCuboids(player.func_130014_f_(), pos);
        return hit != null && cubes != null && hit.subHit >= 0 && hit.subHit < cubes.length ? cubes[hit.subHit] : null;
    }

    public Cuboid6 getCuboidFromRTR(World world, RayTraceResult hit) {
        BlockPos pos;
        BlockPos blockPos = pos = hit == null ? null : hit.func_178782_a();
        if (pos == null) {
            return null;
        }
        Cuboid6[] cubes = this.getCurrentCuboids(world, pos);
        return hit != null && cubes != null && hit.subHit >= 0 && hit.subHit < cubes.length ? cubes[hit.subHit] : null;
    }
}

