/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.crafting.impl;

import com.zeitheron.hammercore.api.EnergyUnit;
import com.zeitheron.hammercore.api.crafting.IBaseIngredient;
import com.zeitheron.hammercore.api.crafting.IGeneralRecipe;
import com.zeitheron.hammercore.api.crafting.impl.EnergyIngredient;
import com.zeitheron.hammercore.api.crafting.impl.FluidStackIngredient;
import com.zeitheron.hammercore.api.crafting.impl.MCIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreIngredient;

public class BaseGeneralRecipe
implements IGeneralRecipe {
    public final ItemStack output;
    public final NonNullList<IBaseIngredient> ingredients;

    public BaseGeneralRecipe(ItemStack output, NonNullList<IBaseIngredient> ingredients) {
        this.output = output;
        this.ingredients = ingredients;
    }

    @Override
    public NonNullList<IBaseIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public ItemStack getRecipeOutputOriginal() {
        return this.output;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final NonNullList<Ingredient> inputItems = NonNullList.func_191196_a();
        private final NonNullList<FluidStack> inputFluid = NonNullList.func_191196_a();
        private final NonNullList<ItemStack> output = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        private double RF;

        public Builder addInput(Ingredient ing) {
            this.inputItems.add((Object)ing);
            return this;
        }

        public Builder addInput(String oredict) {
            this.inputItems.add((Object)new OreIngredient(oredict));
            return this;
        }

        public Builder addInput(FluidStack stack) {
            this.inputFluid.add((Object)stack);
            return this;
        }

        public Builder setEnergy(double amount, EnergyUnit unit) {
            this.RF = unit.getInRF(amount);
            return this;
        }

        public Builder addEnergy(double amount, EnergyUnit unit) {
            this.RF += unit.getInRF(amount);
            return this;
        }

        public Builder withOutput(ItemStack stack) {
            this.output.set(0, (Object)stack);
            return this;
        }

        public double getEnergy(EnergyUnit unit) {
            return unit.getFromRF(this.RF);
        }

        public BaseGeneralRecipe build() {
            NonNullList ings = NonNullList.func_191196_a();
            if (this.RF > 0.0) {
                ings.add((Object)new EnergyIngredient(this.RF, EnergyUnit.RF));
            }
            for (FluidStack stack : this.inputFluid) {
                ings.add((Object)new FluidStackIngredient(stack));
            }
            for (Ingredient ing : this.inputItems) {
                ings.add((Object)new MCIngredient(ing));
            }
            return new BaseGeneralRecipe((ItemStack)this.output.get(0), (NonNullList<IBaseIngredient>)ings);
        }
    }
}

