/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.monster.inborn;

import com.dhanantry.scapeandrunparasites.blocks.BlockInfested;
import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIBlockInfest;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIVenkrolGrow;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIVenkrolSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityCanSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.DataTest;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityVenkrolSII
extends EntityParasiteBase
implements EntityCanSummon {
    private int totalP = SRPAttributes.VENKROLSIITAM;
    private int blockRange = SRPAttributes.VENKROLSII_BLOCKRANGE;
    private int actualP = 0;
    private boolean convert = true;
    private int[] mobID = new int[this.totalP];
    private int[] mobPT = new int[this.totalP];
    private float body = 0.0f;
    private boolean rsSpawned;
    public EntityAIVenkrolSummon summonV = new EntityAIVenkrolSummon(this, SRPAttributes.VENKROLSII_LIMIT, SRPAttributes.VENKROLSII_COOLDOWN, 2, SRPConfig.venkrolsiiCAMinimumV, SRPConfig.venkrolsiiCAExtraM);
    private EntityAIBlockInfest infestation = new EntityAIBlockInfest(this, 2);

    public EntityVenkrolSII(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 3.3f);
        this.canD = SRPConfig.rsDespawn;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.field_70728_aV = SRPAttributes.XP_PRIMITIVE * 2;
        if (SRPAttributes.rsBlockI) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.infestation);
        }
        for (int i = 0; i < this.mobID.length; ++i) {
            this.mobID[i] = -777;
        }
        this.setBODY(1.0f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.summonV);
        this.rsSpawned = false;
        this.killcount = -10.0;
    }

    public void func_70108_f(Entity entityIn) {
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMeleeStatus(this, 1.0, false, 0.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIVenkrolGrow(this, 2, SRPAttributes.VENKROLSII_MINGROWTIME, SRPAttributes.VENKROLSII_MAXGROWTIME));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SRPAttributes.VENKROLSII_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SRPAttributes.VENKROLSII_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(SRPAttributes.VENKROLSII_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.freeDead();
        if (this.getState() == 0) {
            this.setBODY(0.04f);
        } else {
            this.setBODY(-0.04f);
        }
    }

    protected void freeDead() {
        if (!this.field_70170_p.field_72995_K && this.field_70128_L) {
            int meta;
            BlockPos floor;
            World world;
            if (this.convert && (world = this.field_70170_p).func_180495_p(floor = new BlockPos((Entity)this).func_177977_b()).func_177230_c() instanceof BlockInfested && ((meta = world.func_180495_p(floor).func_177230_c().func_176201_c(world.func_180495_p(floor))) == 2 || meta == 12)) {
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g((double)(this.blockRange + 1));
                List moblist = world.func_72872_a(EntityParasiteBase.class, axisalignedbb);
                for (EntityParasiteBase mob : moblist) {
                    if (mob instanceof EntityVenkrolSII && mob == this) continue;
                }
                world.func_175656_a(floor, SRPBlocks.InfestActive.func_176203_a(0));
                world.func_175654_a(floor, SRPBlocks.InfestActive.func_176203_a(0).func_177230_c(), 40, 5);
            }
            if (this.rsSpawned) {
                DataTest data = DataTest.get(this.field_70170_p);
                data.setCurrentV(-1);
            }
        }
    }

    public void setConvert(boolean in) {
        this.convert = in;
    }

    @Override
    public void addID(int id, int points) {
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            this.mobID[i] = id;
            this.mobPT[i] = points;
            return;
        }
    }

    @Override
    public int IDable() {
        int flag = 0;
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            ++flag;
        }
        if (flag > this.totalP) {
            flag = this.totalP;
        }
        return flag;
    }

    @Override
    public void checkID() {
        for (int i = 0; i < this.mobID.length; ++i) {
            Entity flag;
            if (this.mobID[i] <= 0 || (flag = this.field_70170_p.func_73045_a(this.mobID[i])) != null) continue;
            this.mobID[i] = -777;
            int negative = this.mobPT[i] * -1;
            this.setActualParasites(negative);
        }
    }

    @Override
    public int getTotalParasites() {
        return this.totalP;
    }

    @Override
    public int getActualParasites() {
        return this.actualP;
    }

    @Override
    public void setActualParasites(int i) {
        this.actualP += i;
    }

    public void setRSSpawned(boolean in) {
        this.rsSpawned = in;
    }

    public boolean getRSSpawned() {
        return this.rsSpawned;
    }

    public float func_70047_e() {
        return 3.1f;
    }

    public float getBODY() {
        return this.body;
    }

    public void setBODY(float in) {
        if ((in += this.getBODY()) > 0.5f) {
            in = 0.5f;
        }
        if (in < 0.0f) {
            in = 0.0f;
        }
        this.body = in;
    }

    public static void registerFixesVenkrolSII(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityVenkrolSII.class);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        float red = this.getState() == 0 ? 0.6f : 1.0f;
        return super.func_70097_a(source, amount * red);
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("belongtors", this.getRSSpawned());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("belongtors", 99)) {
            this.setRSSpawned(compound.func_74767_n("belongtors"));
        }
    }
}

