/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.monster.inborn;

import com.dhanantry.scapeandrunparasites.blocks.BlockInfested;
import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIBlockInfest;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIVenkrolGrow;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIVenkrolSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityCanSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.DataTest;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVenkrol
extends EntityParasiteBase
implements EntityCanSummon {
    private int totalP = SRPAttributes.VENKROLTAM;
    private int blockRange = SRPAttributes.VENKROL_BLOCKRANGE;
    private int actualP = 0;
    private double buried;
    private boolean convert = true;
    private int[] mobID = new int[this.totalP];
    private int[] mobPT = new int[this.totalP];
    private float body = 0.0f;
    private boolean rsSpawned;
    public EntityAIVenkrolSummon summonV = new EntityAIVenkrolSummon(this, SRPAttributes.VENKROL_LIMIT, SRPAttributes.VENKROL_COOLDOWN, 1, SRPConfig.venkrolCAMinimumV, SRPConfig.venkrolCAExtraM);
    private EntityAIBlockInfest infestation = new EntityAIBlockInfest(this, 1);

    public EntityVenkrol(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 1.9f);
        this.canD = SRPConfig.rsDespawn;
        this.buried = 2.5;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.field_70728_aV = SRPAttributes.XP_INFECTED * 2;
        if (SRPAttributes.rsBlockI) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.infestation);
        }
        for (int i = 0; i < this.mobID.length; ++i) {
            this.mobID[i] = -777;
        }
        this.setBODY(1.0f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.summonV);
        this.rsSpawned = false;
        this.killcount = -10.0;
    }

    public void func_70108_f(Entity entityIn) {
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMeleeStatus(this, 1.0, false, 0.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIVenkrolGrow(this, 1, SRPAttributes.VENKROL_MINGROWTIME, SRPAttributes.VENKROL_MAXGROWTIME));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(SRPAttributes.VENKROL_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(SRPAttributes.VENKROL_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(SRPAttributes.VENKROL_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.buried();
        this.freeDead();
        if (this.getState() == 0) {
            this.setBODY(0.04f);
        } else {
            this.setBODY(-0.04f);
        }
    }

    protected void buried() {
        if (this.buried >= 0.0) {
            this.buried -= 0.08;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected void freeDead() {
        if (!this.field_70170_p.field_72995_K && this.field_70128_L) {
            int meta;
            BlockPos floor;
            World world;
            if (this.convert && (world = this.field_70170_p).func_180495_p(floor = new BlockPos((Entity)this).func_177977_b()).func_177230_c() instanceof BlockInfested && ((meta = world.func_180495_p(floor).func_177230_c().func_176201_c(world.func_180495_p(floor))) == 1 || meta == 11)) {
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g((double)(this.blockRange + 1));
                List moblist = world.func_72872_a(EntityParasiteBase.class, axisalignedbb);
                for (EntityParasiteBase mob : moblist) {
                    if (mob instanceof EntityVenkrol && mob == this) continue;
                }
                world.func_175656_a(floor, SRPBlocks.InfestActive.func_176203_a(0));
                world.func_175654_a(floor, SRPBlocks.InfestActive.func_176203_a(0).func_177230_c(), 40, 5);
            }
            if (this.rsSpawned) {
                DataTest data = DataTest.get(this.field_70170_p);
                data.setCurrentV(-1);
            }
        }
    }

    public void setConvert(boolean in) {
        this.convert = in;
    }

    @Override
    public void addID(int id, int points) {
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            this.mobID[i] = id;
            this.mobPT[i] = points;
            return;
        }
    }

    @Override
    public int IDable() {
        int flag = 0;
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            ++flag;
        }
        if (flag > this.totalP) {
            flag = this.totalP;
        }
        return flag;
    }

    @Override
    public void checkID() {
        for (int i = 0; i < this.mobID.length; ++i) {
            Entity flag;
            if (this.mobID[i] <= 0 || (flag = this.field_70170_p.func_73045_a(this.mobID[i])) != null) continue;
            this.mobID[i] = -777;
            int negative = this.mobPT[i] * -1;
            this.setActualParasites(negative);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double getFloorTimer() {
        return this.buried;
    }

    @Override
    public int getTotalParasites() {
        return this.totalP;
    }

    @Override
    public int getActualParasites() {
        return this.actualP;
    }

    @Override
    public void setActualParasites(int i) {
        this.actualP += i;
    }

    public void setRSSpawned(boolean in) {
        this.rsSpawned = in;
    }

    public boolean getRSSpawned() {
        return this.rsSpawned;
    }

    public float func_70047_e() {
        return 1.7f;
    }

    public float getBODY() {
        return this.body;
    }

    public void setBODY(float in) {
        if ((in += this.getBODY()) > 0.6f) {
            in = 0.6f;
        }
        if (in < 0.0f) {
            in = 0.0f;
        }
        this.body = in;
    }

    public static void registerFixesLodo(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityVenkrol.class);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        float red = this.getState() == 0 ? 0.8f : 1.0f;
        return super.func_70097_a(source, amount * red);
    }

    @Override
    public boolean func_70601_bi() {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return this.func_180484_a(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v)) >= 0.0f && iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("belongtors", this.getRSSpawned());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("belongtors", 99)) {
            this.setRSSpawned(compound.func_74767_n("belongtors"));
        }
    }
}

