/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai;

import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIParasiteFollow;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIWanderStatus;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfCow;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHuman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPig;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSheep;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfVillager;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfWolf;
import com.dhanantry.scapeandrunparasites.events.ParasiteEvent;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.render.particle.ParticleSpawner;
import com.dhanantry.scapeandrunparasites.render.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.DataTest;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityParasiteBase
extends EntityMob {
    public double killcount = 0.0;
    protected boolean canD = true;
    private int waitInt;
    protected int rangeB;
    private boolean canWorkTask;
    private EntityParasiteBase owner;
    private static final DataParameter<Integer> SPECIAL = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SELFE = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityParasiteBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected int lastActiveTime;
    protected int timeSinceIgnited;
    protected int fuseTime = 40;
    protected byte canModRender = 0;
    private int attackCooldown;
    private double madeRng = 0.0;
    protected byte type = 0;
    protected int damageCap = 1;
    protected EntityAIWait wait = new EntityAIWait();
    protected EntityAIParasiteFollow folow = new EntityAIParasiteFollow(this, 1.3, 10.0, 2.0);
    protected EntityAIWanderStatus aiWander = new EntityAIWanderStatus(this, 1.0, 0.001f, true);
    protected EntityAINearestAttackableTarget<EntityPlayer> aiNearestAttackablePlayer = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
    protected EntityAINearestAttackableTarget<EntityLiving> aiAllMobs = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, true, (Predicate)new Predicate<EntityLiving>(){

        public boolean apply(@Nullable EntityLiving entity) {
            return !(entity instanceof EntityWaterMob) && !(entity instanceof EntityCreeper) && !(entity instanceof EntityParasiteBase) && !(entity instanceof EntityAnimal);
        }
    });

    public EntityParasiteBase(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.wait);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.folow);
        this.field_70715_bh.func_75776_a(2, this.aiNearestAttackablePlayer);
        this.attackCooldown = 0;
        if (SRPConfig.mobattacking) {
            this.field_70715_bh.func_75776_a(3, this.aiAllMobs);
        }
        this.rangeB = 1;
        this.canWorkTask = true;
    }

    public boolean func_175446_cd() {
        return super.func_175446_cd();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPECIAL, (Object)0);
        this.field_70180_af.func_187214_a(SELFE, (Object)-1);
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    public void cannotDespawn(boolean in) {
        this.canD = in;
    }

    protected boolean func_70692_ba() {
        return this.canD;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            int k = this.getState();
            if (this.getAttackCooldownAni() != 0 || k == 1 || k == 2) {
                if (this.getAttackCooldownAni() != 0) {
                    int i = this.getAttackCooldownAni() - 1;
                    this.setAttackCooldownAni(i);
                }
                if (k == 1 || k == 2) {
                    if (this.func_70638_az() != null) {
                        if (!this.func_70638_az().func_70089_S()) {
                            this.setState(0);
                        }
                    } else {
                        this.setState(0);
                    }
                }
            }
            if (this.field_70173_aa % 20 == 0 && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.killcount >= 0.0) {
                this.killcount += SRPConfig.killcountplus;
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getWait() > 0) {
            int j1 = this.getWait() - 1;
            if (j1 == 0) {
                this.setState(0);
            }
            this.setWait(j1);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            return super.func_70097_a(source, amount);
        }
        if (this.madeRng == 0.0) {
            this.madeRng = this.func_145782_y();
        }
        float damage = this.func_110138_aP() / (float)this.damageCap + this.func_110138_aP() % (float)this.damageCap * 0.5f;
        if (!this.field_70170_p.field_72995_K && amount >= damage) {
            source.func_76348_h();
        }
        return super.func_70097_a(source, Math.min(amount, damage));
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            this.setAttackCooldownAni(100);
        }
        return flag;
    }

    protected void alertOthers(double rangeXZ, double rangeY) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(rangeXZ, rangeY, rangeXZ);
        List moblist = this.field_70170_p.func_72872_a(EntityParasiteBase.class, axisalignedbb);
        for (EntityParasiteBase mob : moblist) {
            if (mob == null || !mob.func_70089_S() || mob == this || mob.func_70638_az() != null) continue;
            mob.func_70624_b(this.func_70638_az());
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (this.killcount >= 0.0) {
            this.killcount += 1.0;
        }
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 80, 0, false, false));
        this.setWait(10);
    }

    public int getSelfeState() {
        return (Integer)this.field_70180_af.func_187225_a(SELFE);
    }

    public void setSelfeState(int state) {
        this.field_70180_af.func_187227_b(SELFE, (Object)state);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffectIn);
    }

    protected void func_70081_e(int amount) {
        if (!this.field_70178_ae) {
            this.func_70097_a(DamageSource.field_76372_a, (float)amount * SRPConfig.firemultyplier);
        }
    }

    public void setWorkTask(boolean in) {
        this.canWorkTask = in;
    }

    public boolean shouldWorkTask() {
        return this.canWorkTask;
    }

    public int getRangeBlock() {
        return this.rangeB;
    }

    public void setParasiteToFollow(@Nullable EntityParasiteBase in) {
        this.owner = in;
    }

    public EntityParasiteBase getParasiteFollowing() {
        if (this.owner != null) {
            if (this.owner.func_70089_S()) {
                return this.owner;
            }
            this.setParasiteToFollow(null);
        }
        return null;
    }

    public int getState() {
        return (Integer)this.field_70180_af.func_187225_a(SPECIAL);
    }

    public void setState(int state) {
        this.field_70180_af.func_187227_b(SPECIAL, (Object)state);
    }

    public void setWait(int in) {
        this.waitInt = in;
    }

    public int getWait() {
        return this.waitInt;
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    public void setSkin(int texture) {
        this.field_70180_af.func_187227_b(SKIN, (Object)texture);
    }

    public void setAttackCooldownAni(int i) {
        this.attackCooldown = i;
    }

    public int getAttackCooldownAni() {
        return this.attackCooldown;
    }

    public void setKillC(double i) {
        this.killcount = i;
    }

    public double getKillC() {
        return this.killcount;
    }

    public byte getParasiteType() {
        return this.type;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && SRPConfig.rsEnabled) {
            DataTest data = DataTest.get(this.field_70170_p);
            if (SRPConfig.rsPlayer) {
                if (cause.func_76346_g() instanceof EntityPlayer) {
                    long worldT = this.field_70170_p.func_72820_D();
                    long seconds = (worldT - SRPAttributes.lastTimeD1) / 20L;
                    double flag = 100.0 * this.func_70681_au().nextDouble();
                    if (flag <= (double)SRPConfig.rschance && data.getCurrentV() < SRPConfig.rsMaxVenkrols && (long)SRPConfig.rsCooldown < Math.abs(seconds) && ParasiteEvent.SummonM(this, new String[]{"srparasites:venkrol;1;1"}, 7, this.func_70638_az())) {
                        if (SRPConfig.rsSounds) {
                            this.func_184185_a(SRPSounds.VENKROLSI, 4.0f, 1.0f);
                        }
                        data.setCurrentV(1);
                        SRPAttributes.lastTimeD1 = worldT;
                    }
                }
            } else {
                long worldT = this.field_70170_p.func_72820_D();
                long seconds = (worldT - SRPAttributes.lastTimeD1) / 20L;
                double flag = 100.0 * this.func_70681_au().nextDouble();
                if (flag <= (double)SRPConfig.rschance && data.getCurrentV() < SRPConfig.rsMaxVenkrols && (long)SRPConfig.rsCooldown < Math.abs(seconds) && ParasiteEvent.SummonM(this, new String[]{"srparasites:venkrol;1;1"}, 7, this.func_70638_az())) {
                    if (SRPConfig.rsSounds) {
                        this.func_184185_a(SRPSounds.VENKROLSI, 4.0f, 1.0f);
                    }
                    data.setCurrentV(1);
                    SRPAttributes.lastTimeD1 = worldT;
                }
            }
        }
    }

    protected void func_70609_aI() {
        if (this.canModRender == 1) {
            if (Math.floor(this.madeRng) % 3.0 == 0.0) {
                this.setSelfeState(1);
                this.setState(6);
                this.dyingBurst(true, 1);
            } else {
                super.func_70609_aI();
            }
        } else if (this.canModRender == 2) {
            if (Math.floor(this.madeRng) % 3.0 == 0.0) {
                this.selfExplode();
                this.OnDeathHelper();
            } else {
                super.func_70609_aI();
            }
        } else {
            super.func_70609_aI();
        }
    }

    protected void dyingBurst(boolean fromDeath, int value) {
        int i = this.getSelfeState();
        if (i <= 0 || this.timeSinceIgnited == 0) {
            // empty if block
        }
        this.timeSinceIgnited += i * value;
        if (this.timeSinceIgnited < 0) {
            this.timeSinceIgnited = 0;
        }
        if (this.timeSinceIgnited >= this.fuseTime) {
            this.timeSinceIgnited = this.fuseTime;
            this.selfExplode();
            if (fromDeath) {
                this.OnDeathHelper();
            }
        }
    }

    public void OnDeathHelper() {
        if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot"))) {
            int j;
            int i = this.func_70693_a(this.field_70717_bb);
            for (i = ForgeEventFactory.getExperienceDrop((EntityLivingBase)this, (EntityPlayer)this.field_70717_bb, (int)i); i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
        }
    }

    protected void selfExplode() {
        if (this.field_70170_p.field_72995_K) {
            this.spawnEffects();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SRPSounds.MOBEXPLOTION, 1.0f, 1.0f);
            this.field_70729_aU = true;
            this.func_70106_y();
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(1.0f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() - 580);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76436_u, 20, 0));
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public void convertEntity(EntityLivingBase entityLivingIn) {
        if (!this.field_70170_p.field_72995_K) {
            if (entityLivingIn instanceof EntityCow && SRPConfig.infcowEnabled) {
                EntityCow cow = (EntityCow)entityLivingIn;
                EntityInfCow infected = new EntityInfCow(this.field_70170_p);
                infected.func_82149_j((Entity)cow);
                this.field_70170_p.func_72900_e((Entity)cow);
                this.field_70170_p.func_72838_d((Entity)infected);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)this), 0);
                this.particleStatus(7);
                infected.cannotDespawn(false);
            } else if (entityLivingIn instanceof EntitySheep && SRPConfig.infsheepEnabled) {
                EntitySheep cow = (EntitySheep)entityLivingIn;
                EntityInfSheep infected = new EntityInfSheep(this.field_70170_p);
                infected.func_82149_j((Entity)cow);
                this.field_70170_p.func_72900_e((Entity)cow);
                this.field_70170_p.func_72838_d((Entity)infected);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)this), 0);
                this.particleStatus(7);
                infected.cannotDespawn(false);
            } else if (entityLivingIn instanceof EntityWolf && SRPConfig.infwolfEnabled) {
                EntityWolf cow = (EntityWolf)entityLivingIn;
                EntityInfWolf infected = new EntityInfWolf(this.field_70170_p);
                infected.func_82149_j((Entity)cow);
                this.field_70170_p.func_72900_e((Entity)cow);
                this.field_70170_p.func_72838_d((Entity)infected);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)this), 0);
                infected.particleStatus(7);
                infected.cannotDespawn(false);
            } else if (entityLivingIn instanceof EntityPig && SRPConfig.infpigEnabled) {
                EntityPig cow = (EntityPig)entityLivingIn;
                EntityInfPig infected = new EntityInfPig(this.field_70170_p);
                infected.func_82149_j((Entity)cow);
                this.field_70170_p.func_72900_e((Entity)cow);
                this.field_70170_p.func_72838_d((Entity)infected);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)this), 0);
                infected.particleStatus(7);
                infected.cannotDespawn(false);
            } else if (entityLivingIn instanceof EntityVillager && SRPConfig.infvillagerEnabled) {
                EntityVillager cow = (EntityVillager)entityLivingIn;
                EntityInfVillager infected = new EntityInfVillager(this.field_70170_p);
                infected.func_82149_j((Entity)cow);
                this.field_70170_p.func_72900_e((Entity)cow);
                infected.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)infected)), null);
                this.field_70170_p.func_72838_d((Entity)infected);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)this), 0);
                infected.particleStatus(7);
                infected.cannotDespawn(false);
            } else if (entityLivingIn instanceof EntityZombie && SRPConfig.infhumanEnabled) {
                EntityZombie cow = (EntityZombie)entityLivingIn;
                EntityInfHuman infected = new EntityInfHuman(this.field_70170_p);
                infected.func_82149_j((Entity)cow);
                this.field_70170_p.func_72900_e((Entity)cow);
                infected.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)infected)), null);
                this.field_70170_p.func_72838_d((Entity)infected);
                this.field_70170_p.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)this), 0);
                infected.particleStatus(7);
                infected.cannotDespawn(false);
            }
        }
    }

    public boolean func_70601_bi() {
        if (SRPConfig.ignoreL) {
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
            return iblockstate.func_189884_a((Entity)this) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevelTwo() && SRPConfig.spawnDays <= (int)(this.field_70170_p.func_72820_D() / 24000L);
        }
        return super.func_70601_bi() && SRPConfig.spawnDays <= (int)(this.field_70170_p.func_72820_D() / 24000L);
    }

    protected boolean isValidLightLevelTwo() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        int light = this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, blockpos);
        if (light > this.field_70146_Z.nextInt(1000) || light > 7) {
            return false;
        }
        return this.field_70146_Z.nextInt(8) == 0;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("parasitetype", this.getSkin());
        compound.func_74757_a("parasitedespawn", this.func_70692_ba());
        compound.func_74776_a("parasitekills", (float)this.getKillC());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("parasitetype", 99)) {
            this.setSkin(compound.func_74762_e("parasitetype"));
        }
        if (compound.func_150297_b("parasitedespawn", 99)) {
            this.cannotDespawn(compound.func_74767_n("parasitedespawn"));
        }
        if (compound.func_150297_b("parasitekills", 99)) {
            this.setKillC(compound.func_74760_g("parasitekills"));
        }
    }

    public void particleStatus(int id) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)id);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnEffects() {
        if (this.type == 14) {
            for (int i = 0; i <= 60; ++i) {
                if (i % 5 == 0) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 127);
                }
                if (i % 5 != 0) continue;
                this.spawnParticles(SRPEnumParticle.GSPLASH, 1, -1, -1);
            }
            return;
        }
        if (this.type == 31) {
            for (int i = 0; i <= 60; ++i) {
                if (i % 4 == 0) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 150, 0, 0);
                }
                if (i % 5 != 0) continue;
                this.spawnParticles(SRPEnumParticle.GSPLASH, 2, -1, -1);
            }
            return;
        }
        if (this.type == 32) {
            for (int i = 0; i <= 80; ++i) {
                if (i % 3 == 0) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 200, 200, 0);
                }
                if (i % 5 != 0) continue;
                this.spawnParticles(SRPEnumParticle.GSPLASH, 3, -1, -1);
            }
            return;
        }
        for (int i = 0; i <= 60; ++i) {
            if (i % 5 == 0) {
                this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
            }
            if (i % 5 != 0) continue;
            this.spawnParticles(SRPEnumParticle.GSPLASH, 0, -1, -1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 5: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.RHAPPY, 0, 0, 0);
                }
                break;
            }
            case 6: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.CLOUD);
                }
                break;
            }
            case 7: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.EXPLOSION_LARGE);
                }
                break;
            }
            case 8: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
                }
                break;
            }
            case 9: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.CRIT_MAGIC);
                }
                break;
            }
            case 10: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(EnumParticleTypes.CRIT_MAGIC);
                }
                break;
            }
            case 11: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 12: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GCLOUD, 0, 0, 0);
                }
                break;
            }
            case 13: {
                for (int i = 0; i <= 10; ++i) {
                    this.spawnParticles(SRPEnumParticle.GSPLASH, 4, -1, -1);
                }
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(EnumParticleTypes particleType) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(SRPEnumParticle particleType, int r, int g, int b) {
        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
        ParticleSpawner.spawnParticle(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, r, g, b);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSelfeFlashIntensity(float p_70831_1_) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * p_70831_1_) / (float)(this.fuseTime - 2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getscale(float p_70831_1_) {
        return 0.0f;
    }

    class EntityAIWait
    extends EntityAIBase {
        public EntityAIWait() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityParasiteBase.this.getWait() > 0;
        }

        public void func_75246_d() {
        }
    }
}

